# Bielik-11B-v3.0-Instruct
## 论文
[Bielik-11B-v3.0-Instruct](https://github.com/speakleash/bielik-papers/blob/main/v3/Bielik_11B_v3.pdf)

## 模型简介
Bielik-11B-v3.0-Instruct 是一款具有110亿参数的生成式文本模型。该模型是在Bielik-11B-v3-Base-20250730基础上进行指令微调的版本。该模型的诞生见证了开源科研项目SpeakLeash与高性能计算中心ACK Cyfronet AGH的独特合作成果。  
模型基于32种欧洲语言的多语种文本语料进行开发训练，其中波兰语语料经过SpeakLeash团队的精选与系统化处理。该项目充分利用了波兰国家级大规模计算基础设施——特别是PLGrid计算环境中的ACK Cyfronet AGH等高性能计算中心的资源。模型的创建与训练依托计算授权号PLG/2024/016951的支持，在Athena和Helios超级计算机上完成，这些先进计算资源为大规模机器学习过程提供了关键技术保障。  
最终，该模型展现出对波兰语及其他欧洲语言的卓越理解和处理能力，能够提供精准响应，并在多种语言任务中实现高精度性能表现。

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |


推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name Bielik-11B-v3.0-Instruct --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve speakleash/Bielik-11B-v3.0-Instruct  --trust-remote-code --dtype bfloat16  -tp 1  --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "speakleash/Bielik-11B-v3.0-Instruct",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Bielik-11B-v3.0-Instruct | 11B | K100AI | 1 | [下载地址](https://www.modelscope.cn/models/speakleash/Bielik-11B-v3.0-Instruct) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/bielik-11b-v3.0-instruct_vllm

## 参考资料
- https://github.com/speakleash/bielik-papers/tree/main
