# BGE-Reranker
## 论文
暂无

## 模型结构
基于transformers结构
<div align=center>
    <img src="./doc/transformers.png"/>
</div>

## 算法原理
交叉编码器会对输入的成对数据进行全注意力处理，这比embedding模型（即双编码器）更准确，但比embedding模型更耗时。因此，它可以用于对嵌入模型返回的前 k 个文档进行重新排序。
<div align=center>
    <img src="./doc/methods.png"/>
</div>

## 环境配置

DCU型号：BW200/K100_AI 节点数量：1台,卡数：1 张。

`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04.1-rc4-das1.6-py3.10-20250620-fixpy
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/bge-reranker_pytorch
pip install FlagEmbedding
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t bge-reranker:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/bge-reranker_pytorch
pip install FlagEmbedding
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
vllm: 0.8.5
torch: 2.4.1+das.opt2.dtk2504
deepspeed: 0.14.2+das.opt2.dtk2504

```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install FlagEmbedding
```

## 数据集
无

## 训练
暂无

## 推理
### vllm推理方法
#### server

server启动
```bash
vllm serve BAAI/bge-reranker-base --trust-remote-code --port 8002 --served-model-name bge-reranker-base
```

client调用
```bash
curl http://localhost:8002/score \
    -H "Content-Type: application/json" \
    -d '{
        "model": "bge-reranker-base",
        "text_1": "What is the capital of France?",
        "text_2": [
            "The capital of Brazil is Brasilia.",
            "The capital of France is Paris.",
            "Horses and cows are both animals"
        ]
    }'
```

## result
<div align=center>
    <img src="./doc/results-dcu.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 应用场景
### 算法类别
文本分类

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [bge-reranker-base](https://huggingface.co/BAAI/bge-reranker-base)
- [bge-reranker-large](https://huggingface.co/BAAI/bge-reranker-large)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/bge-reranker_pytorch

## 参考资料
- https://github.com/FlagOpen/FlagEmbedding/tree/master/research/reranker
- https://huggingface.co/FacebookAI/xlm-roberta-base
