# bert_large_squad_
## 论文
[BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding](https://arxiv.org/pdf/1810.04805.pdf)
## 模型结构
bert_large_squad核心是transformer,transformer结构如下：

![image](https://developer.hpccube.com/codes/modelzoo/bert_large_squad_onnx/-/raw/main/resources/transformer.png)
## 算法原理
bert_large_squad模型的主要参数为：24个transformer层、1024个hidden size、16个self-attention heads，简要原理可用下图表示：

![image](https://developer.hpccube.com/codes/modelzoo/bert_large_squad_onnx/-/raw/main/resources/squad.png)
## 数据集
暂无合适中文数据集

## 环境配置
在[光源](https://www.sourcefind.cn/#/service-details)可拉取推理的docker镜像。bert_large_squad_onnx推荐的镜像如下：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.15.0_migraphx4.2.2_dtk2404
docker run -d -t --privileged --shm-size=32g --device=/dev/kfd --device=/dev/dri/ --network=host --group-add video --name bert-test -v /opt/hyhal:/opt/hyhal:ro image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.15.0_migraphx4.2.2_dtk2404 bash
docker exec -it bert-test bash
```
在[huggingface](https://huggingface.co/ctuning/mlperf-inference-bert-onnx-fp32-squad-v1.1)下载模型model.onnx到当前目录

预训练权重快速下载中心：[SCNet AIModels](http://113.200.138.88:18080/aimodels) ，项目中的预训练权重可从快速下载通道下载：
[mlperf-inference-bert-onnx-fp32-squad-v1.1](http://113.200.138.88:18080/aimodels/mlperf-inference-bert-onnx-fp32-squad-v1.1) 。

执行fp16转换
```
pip3 install -r requirements.txt
python3 fp16-convert.py
```
## 推理
```
python3 main.py
```

## result
![image](https://developer.hpccube.com/codes/modelzoo/bert_large_squad_onnx/-/raw/main/resources/bert_result.png)
### 精度
暂无
## 应用场景
### 算法类别
对话问答
### 热点应用行业
医疗,科研,金融,教育
## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/bert_large_squad_onnxruntime
## 参考资料
https://github.com/google-research/bert

