# bert_large_squad_onnxruntime
## 论文
[BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding](https://arxiv.org/pdf/1810.04805.pdf)
## 模型结构
bert_large_squad核心是transformer,transformer结构如下：

![image](https://developer.hpccube.com/codes/modelzoo/bert_large_squad_onnx/-/raw/main/resources/transformer.png)
## 算法原理
bert_large_squad模型的主要参数为：24个transformer层、1024个hidden size、16个self-attention heads，简要原理可用下图表示：

![image](https://developer.hpccube.com/codes/modelzoo/bert_large_squad_onnx/-/raw/main/resources/squad.png)
## 数据集
暂无合适中文数据集
## 环境配置
在[光源](https://www.sourcefind.cn/#/service-details)可拉取推理的docker镜像，在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载onnxruntime安装包。bert_large_squad_onnx推荐的镜像如下：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
docker run -d -t --privileged --device=/dev/kfd --device=/dev/dri/ --network=host --group-add video --name bert-test image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```
在[huggingface](https://huggingface.co/ctuning/mlperf-inference-bert-onnx-fp32-squad-v1.1)下载模型model.onnx到当前目录

执行fp16转换
```
pip3 install onnxmltools
python3 fp16-convert.py
```
## 推理
```
python3 main.py
```
## result
![image](https://developer.hpccube.com/codes/modelzoo/bert_large_squad_onnx/-/raw/main/resources/bert_result.png)
### 性能和精度数据
暂无
## 应用场景
### 算法类别
nlp
### 热点应用行业
问答系统
## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/bert_large_squad_onnx
## 参考
https://github.com/google-research/bert

