#!/bin/bash
export HSA_FORCE_FINE_GRAIN_PCIE=1
export MIOPEN_FIND_MODE=3
module unload compiler/rocm/2.9
echo "MIOPEN_FIND_MODE=$MIOPEN_FIND_MODE"
lrank=$OMPI_COMM_WORLD_LOCAL_RANK
comm_rank=$OMPI_COMM_WORLD_RANK
comm_size=$OMPI_COMM_WORLD_SIZE

APP="python3 run_squad_v1.py \
  --train_file  /public/home/hepj/data/sq1.1/train-v1.1.json \
  --predict_file  /public/home/hepj/data/sq1.1/dev-v1.1.json \
  --init_checkpoint  /public/home/hepj/model_source/pytorch_bert/model.ckpt-28252.pt \
  --vocab_file  /public/home/hepj/model_source/pytorch_bert/vocab.txt \
  --output_dir  /public/home/hepj/outdir/tourch/SQuAD \
  --config_file  /public/home/hepj/model_source/pytorch_bert/bert_config.json \
  --json-summary  ./log/results.json \
  --bert_model bert-large-uncased \
  --do_train \
  --do_predict \
  --do_eval \
  --train_batch_size  4 \
  --predict_batch_size 4 \
  --gpus_per_node  1 \
  --local_rank -1 \
  --fp16  \
  --amp  \
  --eval_script ./evaluate-v1.1.py
 "
#--json-summary  /public/home/hepj/out_dir/tourch/SQuAD/results.json 


case ${lrank} in
[0])
  export HIP_VISIBLE_DEVICES=0
  export UCX_NET_DEVICES=mlx5_0:1
  export UCX_IB_PCI_BW=mlx5_0:50Gbs
  echo numactl --cpunodebind=0 --membind=0 ${APP}
  numactl --cpunodebind=0 --membind=0 ${APP}

  #echo GLOO_SOCKET_IFNAME=ib0 numactl --cpunodebind=0 --membind=0 ${APP} 
  #GLOO_SOCKET_IFNAME=ib0 numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])
  export HIP_VISIBLE_DEVICES=1
  export UCX_NET_DEVICES=mlx5_1:1
  export UCX_IB_PCI_BW=mlx5_1:50Gbs
  echo numactl --cpunodebind=1 --membind=1 ${APP}
  numactl --cpunodebind=1 --membind=1 ${APP}
  ;;
[2])
  export HIP_VISIBLE_DEVICES=2
  export UCX_NET_DEVICES=mlx5_2:1
  export UCX_IB_PCI_BW=mlx5_2:50Gbs
  echo numactl --cpunodebind=2 --membind=2 ${APP} 
  numactl --cpunodebind=2 --membind=2 ${APP}
  ;;
[3])
  export HIP_VISIBLE_DEVICES=3
  export UCX_NET_DEVICES=mlx5_3:1
  export UCX_IB_PCI_BW=mlx5_3:50Gbs
  echo numactl --cpunodebind=3 --membind=3 ${APP}
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
esac
