#!/bin/bash
 
lrank=$OMPI_COMM_WORLD_LOCAL_RANK
comm_rank=$OMPI_COMM_WORLD_RANK
comm_size=$OMPI_COMM_WORLD_SIZE

HOME_PATH=""

export OMP_NUM_THREADS=8

#source code path
WORK_HOME="BERT"
#data path
DATA_DIR="BERT/data"
#pretrined model path
MODEL_DIR="bs64k_32k_ckpt"

APP="python3 ${WORK_HOME}/run_squad_v1.py --train_file ${DATA_DIR}/squad/v1.1/train-v1.1.json --init_checkpoint ${MODEL_DIR}/model.ckpt-28252.pt --vocab_file ${MODEL_DIR}/vocab.txt --output_dir ${WORK_HOME}/result/SQuAD --config_file ${MODEL_DIR}/bert_config.json --bert_model=bert-large-uncased --do_train --local_rank ${comm_rank} --train_batch_size 1 --gpus_per_node 1 --dist_url tcp://${1}:45679 --world_size ${comm_size}"

case ${lrank} in
[0])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_0:1
  export UCX_IB_PCI_BW=mlx5_0:50Gbs
  GLOO_SOCKET_IFNAME=ib0 numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_1:1
  export UCX_IB_PCI_BW=mlx5_1:50Gbs
  GLOO_SOCKET_IFNAME=ib0 numactl --cpunodebind=1 --membind=1 ${APP}
  ;;
[2])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_2:1
  export UCX_IB_PCI_BW=mlx5_2:50Gbs
  GLOO_SOCKET_IFNAME=ib0 numactl --cpunodebind=2 --membind=2 ${APP}
  ;;
[3])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_3:1
  export UCX_IB_PCI_BW=mlx5_3:50Gbs
  GLOO_SOCKET_IFNAME=ib0 numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
esac

