# Baichuan
## 论文
无


## 模型结构
Baichuan系列模型是由百川智能开发的开源大规模预训练模型，包含7B和13B等规模。其中，Baichuan-7B在大约1.2万亿tokens上训练的70亿参数模型，支持中英双语，上下文窗口长度为4096。

模型具体参数：

| 模型名称 | 隐含层维度 | 层数 | 头数 | 词表大小 | 总参数量 | 训练数据(tokens) | 位置编码 | 最大长 |
| -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- |
| Baichuan-7B | 4,096 | 32 | 32 | 64,000 | 7,000,559,616 | 1.2万亿 | RoPE | 4096 |


![img](./docs/baichuan.jpg)

## 算法原理
Baichuan整体模型基于标准的Transformer结构，采用了和LLaMA一样的模型设计。其中，Baichuan-7B在结构上采用Rotary Embedding位置编码方案、SwiGLU激活函数、基于RMSNorm的Pre-Normalization。
![img](./docs/baichuan.png)


## 环境配置

提供光源拉取推理的docker镜像：
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10(推荐)
# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name baichuan --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal:ro --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
```
镜像版本依赖：
* DTK驱动：24.04.1
* Pytorch: 2.1.0
* python: python3.10



## 数据集
无

## 推理

### 源码编译安装
```bash
# 若使用光源的镜像，可以跳过源码编译安装，镜像里面安装好了lmdeploy。
git clone http://developer.hpccube.com/codes/modelzoo/baichuan_lmdeploy.git
cd llama_lmdeploy
git submodule init && git submodule update
cd lmdeploy
mkdir build && cd build
sh ../generate.sh
make -j 32
make install
cd .. && python3 setup.py install
```
### 模型下载
预训练权重快速下载中心：
[SCNet AIModels](http://113.200.138.88:18080/aimodels)

项目中的预训练权重快速通道下载地址：
http://113.200.138.88:18080/aimodels/Baichuan-7B

http://113.200.138.88:18080/aimodels/Baichuan2-7B-Chat

官方下载地址：
[baichuan-7b](https://huggingface.co/baichuan-inc/Baichuan-7B)

[baichuan2-7b-chat](https://huggingface.co/baichuan-inc/Baichuan2-7B-Chat)

### 运行前

```bash
#step 1
cd lmdeploy
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
#step 2
source /opt/dtk/cuda/env.sh
```


### 运行 baichuan-7b-chat
```bash
# <tp> 用于张量并行的GPU数量应该是2^n
# bash界面运行
lmdeploy chat turbomind  ./path_to_baichuan7b --tp 1     # 输入问题后执行2次回车进行推理

# 服务器网页端运行
在bash端运行：
# <server-name> gradio服务器的ip地址
# <server-port> gradio服务器的ip的端口
# <tp> 用于张量并行的GPU数量应该是2^n （和模型转换的时候保持一致）
lmdeploy serve gradio  ./path_to_baichuan7b --server-name {ip} --server-port {port} --tp 1

在网页上输入{ip}:{port}即可进行对话
```

### 运行 baichuan2-7b
```bash
# bash界面运行
lmdeploy chat turbomind ./path_to_baichuan2-7b --tp 1

# 服务器网页端运行

在bash端运行：
lmdeploy serve gradio ./path_to_baichuan2-7b --server-name {ip} --server-port {port} --tp 1

在网页上输入{ip}:{port}即可进行对话
```

## result
![baichuan](docs/baichuan.gif)

### 精度

无

## 应用场景

### 算法类别

`对话问答`


### 热点应用行业

`医疗,教育,科研,金融`

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/baichuan_lmdeploy

## 参考资料
https://github.com/InternLM/LMDeploy
