# Copyright 2023-present, Argilla, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from pydantic import BaseModel

from distilabel.utils.serialization import _extra_serializable_fields, _Serializable


def test_extra_serializable_fields() -> None:
    class DummyAttribute(BaseModel, _Serializable):
        pass

    class Dummy(BaseModel, _Serializable):
        attr: DummyAttribute

    dummy = Dummy(attr=DummyAttribute())

    assert _extra_serializable_fields(dummy) == [
        {
            "attr": {
                "type_info": {
                    "module": "tests.unit.utils.test_serialization",
                    "name": "DummyAttribute",
                }
            }
        }
    ]
