---
hide:
  - navigation
  - toc
---
# Components Gallery

??? info "Category Overview" 
    | Icon                       | Category   | Description                                                       |
    |----------------------------|------------|-------------------------------------------------------------------|
    | :material-step-forward:    | Steps      | Steps are used for data manipulation.                            |
    | :material-check-outline:   | Tasks      | Tasks allow performing data generation, annotation, and more.    |
    | :material-brain:           | LLMs       | Explore all available Large Language Models integrated with distilabel. |
    | :material-vector-line:     | Embeddings | Explore all available Embeddings Models integrated with distilabel.    |

<div class="grid cards" markdown>

-   :material-step-forward:{ .lg .middle } __Steps__

    ---

    Explore all the available `Step`s that can be used for data manipulation.

    [:octicons-arrow-right-24: Steps](steps/index.md){ .bottom }

-   :material-check-outline:{ .lg .middle } __Tasks__

    ---

    Explore all the available `Task`s that can be used with an `LLM` to perform data generation, annotation, and more.

    [:octicons-arrow-right-24: Tasks](tasks/index.md)

-   :material-brain:{ .lg .middle } __LLMs__

    ---

    Explore all the available `LLM`s integrated with `distilabel`.

    [:octicons-arrow-right-24: LLMs](llms/index.md){ .bottom }

-   :material-image:{ .lg .middle } __ImageGenerationModels__

    ---

    Explore all the available `ImageGenerationModels`s integrated with `distilabel`.

    [:octicons-arrow-right-24: ImageGenerationModels](image_generation/index.md){ .bottom }

-   :material-vector-line:{ .lg .middle } __Embeddings__

    ---

    Explore all the available `Embeddings` models integrated with `distilabel`.

    [:octicons-arrow-right-24: Embeddings](embeddings/index.md){ .bottom }

</div>
