# Copyright 2023-present, Argilla, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import List


def flatten_responses(responses: List[List[str]]) -> List[str]:
    """Flattens the list of lists of strings into a single list of strings.

    Args:
        responses: The list of lists of strings to flatten.

    Returns:
        A single list of strings containing the last item of each list.
    """
    return [response[-1] for response in responses]
