# asr_onnx
## 模型介绍
语音识别模型asr,speech-to-text(stt)
## 模型结构
![image](https://developer.hpccube.com/codes/modelzoo/asr_onnx/-/blob/main/resources/silero_stt_model.jpg)
## 推理
### 环境配置
在[光源](https://www.sourcefind.cn/#/service-details)可拉取推理的docker镜像，在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载onnxruntime安装包。asr_onnx推荐的镜像如下：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py37-latest
```
获取最新的dtk并安装依赖
```
cd /opt
wget http://10.0.50.210:8000/jenkins/rocm/23.04.1/centos7/DTK-23.04.1-rc4-centos7-x86_64.tar.gz
tar -zxvf DTK-23.04.1-rc4-centos7-x86_64.tar.gz
source /opt/dtk-23.04.1/env.sh
```
下载模型(https://models.silero.ai/models/en/en_v5.onnx)到当前目录
### 推理
```
python3 main.py --model_dir="./en_v5.onnx" --wav_dir="./wavs/" --warmup=1
```
## 性能数据
| size | infer time(ms)| infer time after warmup(ms)| 
| :------: | :------: | :------: |
| (4,262144) | 7.6759592751041055 | 0.040782203897833824 | 
| (4,524288) | 7.950103935785592 | 0.061228943057358265 | 
| (4,1048576) | 8.080759830772877 | 0.11008367035537958 | 
| (4,2097152) | 8.469960468821228 | 0.2672890517860651 | 

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/asr_onnx
## 参考
* [silero-models](https://github.com/snakers4/silero-models)

