# arcface
## 论文
- https://arxiv.org/pdf/1801.07698.pdf
## 模型结构
这篇文章提出一种新的用于人脸识别的损失函数：additive angular margin loss，直接在角度空间（angular space）中最大化分类界限，基于该损失函数训练得到人脸识别算法ArcFace。
<div align=center>
    <img src="./docs/arcface.png"/>
</div>

## 算法原理
通过训练深度卷积神经网络嵌入 (DCNN Embedding) 来进行人脸识别。  
ArcFace训练流程：  
<div align=center>
    <img src="./docs/legend.png"/>
</div>  

<div align=center>
    <img src="./docs/train.jpg"/>
</div>


## 环境配置
### Docker（方法一）
从[光源](https://www.sourcefind.cn/#/service-list)中拉取docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.2-py3.10
```
创建容器并挂载目录进行开发：
```
docker run -it --name {name} --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v {}:{} {docker_image} /bin/bash
# 修改1 {name} 需要改为自定义名称，建议命名{框架_dtk版本_使用者姓名},如果有特殊用途可在命名框架前添加命名
# 修改2 {docker_image} 需要需要创建容器的对应镜像名称，如: pytorch:1.10.0-centos7.6-dtk-23.04-py37-latest【镜像名称:tag名称】
# 修改3 -v 挂载路径到容器指定路径
pip install -r requirements.txt
```
### Dockerfile（方法二）
```
cd docker
docker build --no-cache -t arcface_pytorch:1.0 .
docker run -it --name {name} --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v {}:{} {docker_image} /bin/bash 
pip install -r requirements.txt
```
### Anaconda（方法三）
线上节点推荐使用conda进行环境配置。
创建python=3.10的conda环境并激活
```
conda create -n arcface python=3.10
conda activate arcface
```

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk24.04.2
python：python3.10
pytorch:2.1.0
torchvision:0.16.0
```
安装其他依赖包
```
pip install -r requirements.txt
```
## 数据集
`MS1MV2\IJBC`

- 训练集[faces_emore.zip](https://pan.baidu.com/s/1S6LJZGdqcZRle1vlcMzHOQ)，SCNet下载链接[faces_emore.zip](http://113.200.138.88:18080/aidatasets/project-dependency/arcface_pytorch)  
下载后解压到当前目录  
数据目录结构如下：
```
 ── faces_emore
    |   agedb_30.bin
    |   calfw.bin
    |   cfp_ff.bin
    |   cfp_fp.bin
    |   cplfw.bin
    |   lfw.bin
    |   property
    |   train.idx
    |   train.rec
    |   vgg2_fp.bin
```
- 测试集[IJBC.zip](https://pan.baidu.com/s/1Ok4sqTO8vqAE_kG3zV1rqw?pwd=1234),   
解压分卷压缩文件：
```
# 将所有的分卷压缩文件放在一个文件夹中
zip -s 0 IJBC.zip --out IJBC_ALL.zip
unzip IJBC_ALL.zip
```
SCNet下载链接[IJBC.zip](http://113.200.138.88:18080/aidatasets/project-dependency/arcface_pytorch)，通过SCNet下载的压缩文件解压并将文件夹重命名为IJBC_ALL  
## 训练
Backbone使用ResNet100，在MS1MV3数据集上的预训练权重文件为[model.pt](https://pan.baidu.com/s/1W-TisIZtZmRQz32hq5T6Uw?pwd=1234)，SCNet下载链接[model.pt](http://113.200.138.88:18080/aidatasets/project-dependency/arcface_pytorch)    
在对应configs文件中修改模型保存路径和训练数据的加载路径，比如说：  
在configs/ms1mv2_r100.py中修改数据加载路径[config.rec](./configs/ms1mv2_r100.py#L22)   
在configs/base.py中修改模型保存路径[config.output](./configs/base.py#L14)，模型名称可以在train_v2.py中修改，默认为[model.pt](train_v2.py#L228)  

### 单机单卡
```
python train_v2.py configs/ms1mv2_r100.py
```

### 单机多卡
```
torchrun --nproc_per_node=4 train_v2.py configs/ms1mv2_r100.py
```

### 测试
下载权重文件和测试数据集，测试模型精度：
```
python eval_ijbc.py --model-prefix model.pt --image-path IJBC_ALL --network r100
```

## result
<div align=center>
    <img src="search_identities.png"/>
</div>

### 精度
模型在MS1MV2数据集的测试指标：
| 模型 | 数据类型 | AUC |
| :------: | :------: | :------: |
| [r34](https://pan.baidu.com/s/1LR0zm8AxwN2tZH55xQdzHw?pwd=1234) | fp16 | 99.5611% |
| [r50](https://pan.baidu.com/s/128GP5J-jWvNbQAAur68bHw?pwd=1234) | fp16 | 99.5616% |
| [r100](https://pan.baidu.com/s/1e4Qg2i6wqyBCcwgA-dA8xw?pwd=1234) | fp16 | 99.5767% |

## 应用场景
### 算法类别
人脸识别

### 热点应用行业
安防,交通,教育


## 源码仓库及问题反馈
[https://developer.hpccube.com/codes/modelzoo/arcface_pytorch](https://developer.hpccube.com/codes/modelzoo/arcface_pytorch)
## 参考资料
[https://github.com/deepinsight/insightface/tree/master/recognition/arcface_torch](https://github.com/deepinsight/insightface/tree/master/recognition/arcface_torch)


