# AprielGuard
## 论文
[AprielGuard](https://arxiv.org/pdf/2512.20293)

## 模型简介
AprielGuard是一款拥有80亿参数的安全防护模型，旨在检测并缓解大语言模型交互中可能出现的各类安全风险（例如有害内容、偏见、错误信息）与安全威胁（例如提示词注入、越狱攻击、间接提示攻击）。与传统分别处理这些领域的审核工具不同，AprielGuard在统一的分类体系和训练框架下整合了安全与对抗性风险的识别能力，为独立提示、多轮对话以及智能体工作流提供全面的内容审核解决方案。  
核心亮点：
- 统一框架：单一模型即可同时检测内容安全风险与对抗性攻击威胁。   
- 多类型输入支持：可处理独立提示、多轮对话及智能体工作流场景。  
- 结构化推理追踪：支持启用或关闭推理模式。启用时，模型将提供可解释的决策依据。   
- 智能体感知审核：能够识别推理链、工具调用序列及API执行过程中涌现的新型威胁。   
- 轻量可部署：模型紧凑轻量，经过优化便于集成至生产流程或评估体系。

<div align=center>
    <img src="./doc/perf.png"/>
</div>
## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

推荐使用镜像:image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name AprielGuard --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve ServiceNow-AI/AprielGuard  --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1 --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "ServiceNow-AI/AprielGuard",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| AprielGuard | 8B | K100AI | 1 | [下载地址](https://huggingface.co/ServiceNow-AI/AprielGuard) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/aprielguard_vllm

## 参考资料
- https://huggingface.co/ServiceNow-AI/AprielGuard
