# Apriel
## 论文
[Apriel](https://arxiv.org/pdf/2510.01141)
## 模型简介
Apriel-1.6-15B-Thinker是ServiceNow公司Apriel系列轻量级语言模型中的一款升级版多模态推理模型，基于前代Apriel-1.5-15B-Thinker架构演进。该模型在文本与图像推理能力上实现显著提升，其综合性能可对标规模达自身10倍的大型模型。沿袭前代模型的技术路径，该版本继续受益于跨文本与图像领域的持续大规模预训练。并进一步实施了以监督微调（SFT）和强化学习（RL）为核心的后期训练策略。Apriel-1.6在保持高效推理token使用的前提下实现了前沿性能表现。相较于Apriel-1.5-15B-Thinker，该模型在维持或提升各项任务性能指标的同时，将推理token消耗量降低了30%以上。  

该模型仅凭150亿参数规模，即可实现与远超其体量的大模型相当甚至更优的智能评分。在性能图表中，它稳固地位于最具吸引力的象限，在计算效率与顶级推理能力之间取得卓越平衡。实际应用中，这意味着Apriel-1.6-15B-Thinker能以重量级竞品几分之一的计算与部署成本，提供强劲的性能表现与深度推理能力，使其成为现实场景（尤其是企业级应用）中极具效率优势的选择方案。



<div align=center>
    <img src="./doc/perf.png"/>
</div>

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name Apriel --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动
vllm serve ServiceNow-AI/Apriel-1.6-15b-Thinker    --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1   --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8000/v1/chat/completions"   -H "Content-Type: application/json"     --data '{
                "model": "ServiceNow-AI/Apriel-1.6-15b-Thinker",
                "messages": [
                        {
                                "role": "user",
                                "content": [
                                        {
                                                "type": "text",
                                                "text": "Describe this image in one sentence."
                                        },
                                        {
                                                "type": "image_url",
                                                "image_url": {
                                                        "url": "https://img-s.msn.cn/tenant/amp/entityid/AA1S6LMz.img?w=640&h=427&m=6"
                                                }
                                        }
                                ]
                        }
                ]
        }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Apriel-1.6-15b-Thinker | 15B | K100AI | 1 | [下载地址](https://huggingface.co/ServiceNow-AI/Apriel-1.6-15b-Thinker) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/apriel_vllm

## 参考资料
- https://hf-mirror.com/blog/ServiceNow-AI/apriel-1p6-15b-thinker
