# AnyText

## 论文

**AnyText: Multilingual Visual Text Generation And Editing**

* https://arxiv.org/abs/2311.03054

## 模型结构

模型由4部分构成，分别是`Auxiliary Latent Module`，`Text Embedding Module`，`Text-control Diffusion Pipeline`以及`Text Preceptual Loss`。

其中，`Auxiliary Latent Module`可产生3种附加信息用以生成$`Z_a`$，其中$`l_g`$表示字形信息，$`l_p`$表示文字的位置信息，$`l_m`$表示被遮盖的图像（保留背景信息）。

`Text Embedding`用于生成$`c_{te}`$，$`y'`$表示待生成的文字，$`e_g`$表示待生成文字的图像信息，$`y_{\theta}`$表示OCR识别模型（用于提取文字特征），$`\xi`$表示线性层（用于约束特征尺寸），$`\tau_{\theta}`$表示encoder（CLIP）。

`Text-control Diffusion Pipeline`用于生成目标结果，$`z_0`$加噪t次后获得$`z_t`$，`Text ControlNet`用于生成控制信息（copy from Unet's Encoder），$`L_{td}`$表示扩散模型损失。

`Text Preceptual Loss`用于进一步提升文字生成的准确率。

![Alt text](readme_imgs/image-1.png)

## 算法原理
该算法借鉴ControlNet思想，并在此基础上结合了文字，图像位置等多模态信息条件，可用于多语言文本的图像生成。

![Alt text](readme_imgs/image-2.png)

## 环境配置


### Docker（方法一）

    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
    docker run --shm-size 10g --network=host --name=anytext --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -it <your IMAGE ID> bash

    cd BasicSR
    pip install -r requirements.txt
    cd ..
    pip install -r requirements.txt

### Dockerfile（方法二）

    # 需要在对应的目录下
    docker build -t <IMAGE_NAME>:<TAG> .
    # <your IMAGE ID>用以上拉取的docker的镜像ID替换
    docker run -it --shm-size 10g --network=host --name=anytext --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined <your IMAGE ID> bash

    cd BasicSR
    pip install -r requirements.txt
    cd ..
    pip install -r requirements.txt

### Anaconda (方法三)
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk24.04.1
    python：python3.10
    torch:2.1.0
    torchvision:0.16.0
    torchaudio:2.1.2
    deepspeed:0.12.3
    apex:1.1.0

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    cd BasicSR
    pip install -r requirements.txt
    cd ..
    pip install -r requirements.txt

## 数据集

无（等待更新）

## 推理

### 字体下载

    下载并重命名
    arialuni.ttf -> Arial_Unicode.ttf

    文件结构
    font/
    └── Arial_Unicode.ttf

### 命令行

    # 快速运行
    export ATTN_PRECISION=fp16
    python inference.py

    # graido客户端运行
    export ATTN_PRECISION=fp16
    python demo.py

## result

![Alt text](readme_imgs/image-3.jpg)

![Alt text](readme_imgs/image-4.png)

### 精度

无

## 应用场景

### 算法类别

`AIGC`

### 热点应用行业

`零售,广媒,设计`

## 预训练权重

原始链接：[clip](https://huggingface.co/openai/clip-vit-large-patch14/tree/main) | [anytext](https://modelscope.cn/models/iic/cv_anytext_text_generation_editing/files)

[SCNet](http://113.200.138.88:18080/aimodels)高速通道：[clip](http://113.200.138.88:18080/aimodels/clip-vit-large-patch14) | [anytext](http://113.200.138.88:18080/aimodels/cv_anytext_text_generation_editing)


    damo/
    └── cv_anytext_text_generation_editing
        ├── anytext_v1.1.ckpt
        ├── clip-vit-large-patch14
        │   ├── config.json
        │   ├── merges.txt
        │   ├── preprocessor_config.json
        │   ├── pytorch_model.bin
        │   ├── README.md
        │   ├── special_tokens_map.json
        │   ├── tokenizer_config.json
        │   ├── tokenizer.json
        │   └── vocab.json
        ├── configuration.json
        ├── description
        │   ├── eval.jpg
        │   ├── framework.jpg
        │   ├── gallary.png
        │   └── sample.jpg
        ├── ms_wrapper.py
        ├── nlp_csanmt_translation_zh2en
        │   ├── bpe.en
        │   ├── bpe.zh
        │   ├── configuration.json
        │   ├── README.md
        │   ├── resources
        │   │   ├── csanmt-model.png
        │   │   ├── ctl.png
        │   │   └── sampling.png
        │   ├── src_vocab.txt
        │   ├── tf_ckpts
        │   │   ├── checkpoint
        │   │   ├── ckpt-0.data-00000-of-00001
        │   │   ├── ckpt-0.index
        │   │   └── ckpt-0.meta
        │   ├── train.en
        │   ├── train.zh
        │   └── trg_vocab.txt
        └── README.md


## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/anytext_pytorch

## 参考资料

https://github.com/tyxsspa/AnyText
