<!--
 * @Author: zhuww
 * @email: zhuww@sugon.com
 * @Date: 2023-04-06 18:04:07
 * @LastEditTime: 2023-08-24 09:34:01
-->
# AlphaFold2
## 论文
- [https://www.nature.com/articles/s41586-021-03819-2](https://www.nature.com/articles/s41586-021-03819-2)

## 模型结构
模型核心是一个基于Transformer架构的神经网络，包括两个主要组件：Sequence to Sequence Model和Structure Model，这两个组件通过迭代训练进行优化，以提高其预测准确性。

## 算法原理
AlphaFold2通过从蛋白质序列和结构数据中提取信息，使用神经网络模型来预测蛋白质三维结构。

## 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:alphafold2-2.2.1-centos7.6-dtk-22.04.2-py38
docker run -it --name alphafold --shm-size=32G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video image.sourcefind.cn:5000/dcu/admin/base/custom:alphafold2-2.2.1-centos7.6-dtk-22.04.2-py38 /bin/bash
```

镜像版本依赖：
* DTK驱动：dtk22.04.2
* Jax: 0.3.14
* TensorFlow2: 2.10.0
* python: python3.8

激活镜像环境：

`source /opt/dtk-22.04.2/env.sh`

`source /opt/openmm-hip/env.sh`

测试目录：

`/opt/docker/test/alphafold`

## 数据集
推荐使用AlphaFold2中的开源数据集，包括BFD、MGnify、PDB70、Uniclust、Uniref90等,数据集大小约3TB。

此处提供了一个脚本download_all_data.sh用于下载使用的数据集和模型文件：

    ./scripts/download_all_data.sh 数据集下载目录

## 推理
分别提供了基于Jax的单体和多体的推理脚本.
设置DOWNLOAD_DIR路径和output_dir路径。确保输出目录存在，并且您有足够的权限对其进行写入。

    # Set to target of download all databases
    DOWNLOAD_DIR = '/path/to/database'
    
    # Path to a directory that will store the results.
    output_dir = '/path/to/output_dir'

### 单体

    python3 run_alphafold.py \
    --fasta_paths=monomer.fasta \
    --output_dir=./ \
    --max_template_date=2020-05-14 \
    --model_preset=monomer \
    --run_relax=true \
    --use_gpu_relax=true

或者使用`./run_monomer.sh`

#### 单体推理参数说明
monomer.fasta为推理的单体序列；--output_dir为输出目录；--model_preset选择模型配置；--run_relax=true为进行relax操作；--use_gpu_relax=true为使用gpu进行relax操作（速度更快，但可能不太稳定），--use_gpu_relax=false为使用CPU进行relax操作（速度慢，但稳定）；
若添加--use_precomputed_msas=true则可以加载已经搜索对齐的序列，否则默认进行搜索对齐；

### 多体

    python3 run_alphafold.py \
    --fasta_paths=multimer.fasta \
    --output_dir=./ \
    --uniprot_database_path=/data/uniprot/uniprot_trembl.fasta \
    --pdb_seqres_database_path=/data/pdb_seqres/pdb_seqres.txt \
    --pdb70_database_path= \
    --max_template_date=2020-05-14 \
    --model_preset=multimer \
    --run_relax=true \
    --use_gpu_relax=true

或者使用`./run_multimer.sh`

#### 多体推理参数说明
multimer.fasta为推理的多体序列，data为数据集下载路径，其他参数同单体推理参数说明一致。

## result
`--output_dir`目录结构如下：
```
<target_name>/
    features.pkl
    ranked_{0,1,2,3,4}.pdb
    ranking_debug.json
    relaxed_model_{1,2,3,4,5}.pdb
    result_model_{1,2,3,4,5}.pkl
    timings.json
    unrelaxed_model_{1,2,3,4,5}.pdb
    msas/
        bfd_uniclust_hits.a3m
        mgnify_hits.sto
        uniref90_hits.sto
        ...
```

## 精度
测试数据：[casp14](https://www.predictioncenter.org/casp14/targetlist.cgi)、[uniprot](https://www.uniprot.org/)，
使用的加速卡:1张 DCU 1代-16G

准确性数据：
| 数据类型 | 序列类型 | 序列标签 | 序列长度 | GDT-TS | GDT-HA | LDDT | TM score | MaxSub | RMSD |
| :------: | :------: | :------: | :------: |:------: |:------: | :------: | :------: | :------: |:------: |
| fp32 | 单体 | T1026 | 172 | 0.849 | 0.658 | 75.050 | 0.901 | 0.851 | 1.6 |
| fp32 | 单体 | T1053 | 580 | 0.941 | 0.789 | 92.316 | 0.985 | 0.935 | 1.1 |
| fp32 | 单体 | T1091 | 863 | 0.492 | 0.332 | 85.083 | 0.740 | 0.388 | 6.7 |

## 应用场景

### 算法类别
NLP

### 热点应用行业
医疗,科研,教育



## 源码仓库及问题反馈
* [https://developer.hpccube.com/codes/modelzoo/AlphaFold2](https://developer.hpccube.com/codes/modelzoo/AlphaFold2)

## 参考
* [https://github.com/deepmind/alphafold](https://github.com/deepmind/alphafold)

