#!/bin/bash

# /*即使下载了镜像依旧可能无法使用，因此在这里对一些容易出问题的库编译*/

# hh-suite

platform_is_intel=`lscpu | grep 'Model name' | grep -q "Intel" && echo "true" || echo "false"` 

echo $platform_is_intel

if [ "${platform_is_intel}" = "true" ]; then
    echo "build for intel"
    cd /app/softwares/hh-suite
    rm -rf build
    mkdir -p build && cd build && cmake -DCMAKE_INSTALL_PREFIX=. .. && make -j 8 && make install
else
    echo "build for others"
    cd /app/softwares/hh-suite
    rm -rf build
    mkdir -p build && cd build && cmake -DHAVE_AVX2=1 -DCMAKE_INSTALL_PREFIX=. .. && make -j 8 && make install
fi

# openmm-8.0.0

echo "build openmm-8.0.0"

cd /app/softwares

rm -rf build build-hip install

mkdir build build-hip install

cd build && cmake ../openmm-8.0.0/ -D CMAKE_INSTALL_PREFIX=../install -D OPENMM_BUILD_COMMON=ON -D OPENMM_PYTHON_USER_INSTALL=ON && make && sudo make install && sudo make PythonInstall

# openmm-hip

cd /app/softwares

cd build-hip && cmake ../openmm-hip/ -D OPENMM_DIR=../install -D OPENMM_SOURCE_DIR=../openmm-8.0.0 -D CMAKE_INSTALL_PREFIX=../install && make && sudo make install

