# AlignedReID
## 论文
[AlignedReID](https://www.sciencedirect.com/science/article/pii/S0031320319302031?via%3Dihub#!)

## 模型简介
AlignedReID是旷视科技提出的行人重识别（ReID）算法，首次在该任务上实现超越人类水平的性能。其核心通过局部特征对齐优化，显著提升了细节特征的捕捉能力。

#### 核心方法
**局部对齐：** 采用动态规划计算局部最短路径，确保身体各部分相对顺序正确，同时最小化对齐距离 。 ‌
**损失函数：** 将最短路径长度纳入局部损失，辅助学习整体特征 。 ‌‌
**数据集支持:**主要使用Market1501数据集，包含训练集（751人，12,936张图）、测试集（750人，19,732张图）和查询集（750人，3,368张图） 。 ‌‌
**代码实现**
**PyTorch框架：** 支持数据集加载、特征提取及损失计算 。 ‌
**关键函数：** shortest_dist（动态规划计算最短路径）、local_dist（局部特征匹配） 。 ‌‌
**性能优势:** 通过局部细节优化，有效解决遮挡、姿态变化等挑战，成为行人重识别领域的基准方法之一 。


## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.8e22ded.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name minimax_m2 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
在此仓库下创建一个目录来存储 reid 数据集：
```bash
bash
cd AlignedReID/
mkdir data/
```
### Market1501
1. 下载数据集到 `data/` ，下载地址：http://www.liangzheng.org/Project/project_reid.html.
2. 解压数据后重命名为 `market1501`. 数据结构应如下所示:
```
market1501/
    bounding_box_test/
    bounding_box_train/
    ...
```
3. 启动训练代码时，使用参数 `-d market1501` 进行数据集选择
### CUHK03
1、在 data/ 下创建一个名为 cuhk03/ 的文件夹。

2、从 http://www.ee.cuhk.edu.hk/~xgwang/CUHK_identification.html 下载数据集到 data/cuhk03/ 并解压 cuhk03_release.zip，这样您将拥有 data/cuhk03/cuhk03_release。

3、从 person-re-ranking 下载新划分 [14]。您需要的是 cuhk03_new_protocol_config_detected.mat 和 cuhk03_new_protocol_config_labeled.mat。将这两个 mat 文件放在 data/cuhk03 下。最终的数据结构如下所示：
```
cuhk03/
    cuhk03_release/
    cuhk03_new_protocol_config_detected.mat
    cuhk03_new_protocol_config_labeled.mat
    ...
```

4、运行训练代码时使用 -d cuhk03。默认模式下，我们使用新划分 (767/700)。如果您想使用 [13] 创建的原始划分 (1367/100)，请指定 --cuhk03-classic-split。由于 [13] 的 CMC 计算方式与 Market1501 不同，您可能需要指定 --use-metric-cuhk03 以与其方法进行公平比较。此外，我们支持 labeled 和 detected 两种模式。默认模式加载 detected 图像。如果您想在 labeled 图像上训练和测试，请指定 --cuhk03-labeled。
### DukeMTMC-reID
1、在 data/ 下创建一个名为 dukemtmc-reid 的目录。
2、从 https://github.com/layumi/DukeMTMC-reID_evaluation#download-dataset 下载数据集 DukeMTMC-reID.zip 并将其放到 data/dukemtmc-reid。解压 zip 文件，结果如下：
```bash
dukemtmc-reid/
    DukeMTMC-reid.zip # (您可以删除这个 zip 文件，没关系)
    DukeMTMC-reid/ # 此文件夹包含 8 个文件。
```
3、运行训练代码时使用 -d dukemtmcreid
### MSMT17 
1、在 data/ 下创建一个名为 msmt17/ 的目录。
2、从 http://www.pkuvmc.com/publications/msmt17.html 下载数据集 MSMT17_V1.tar.gz 到 data/msmt17/。在同一文件夹下解压该文件，这样您将拥有：
```bash
msmt17/
    MSMT17_V1.tar.gz # (您可以随意处理这个 .tar 文件)
    MSMT17_V1/
        train/
        test/
        list_train.txt
        ... (总共六个 .txt 文件)
```
3、运行训练代码时使用 -d msmt17
## 训练
我们建议使用CUHK03数据集和MSMT17数据集进行未来研究训练，命令如下：
```bash
python train_alignedreid.py  -d cuhk03 -a resnet50 --test_distance global_local --reranking (--labelsmooth)
```

## 推理
全局+局部(DMLI)
```bash
python train_alignedreid.-d cuhk03 -a resnet50 --evaluate --resume YOUR_MODEL_PATH --save-dir log/resnet50-cuhk03-alignedreid --test_distance global_local (--reranking)
```
局部(DMLI)
```bash
python train_alignedreid.py -d cuhk03 -a resnet50 --evaluate --resume YOUR_MODEL_PATH --save-dir log/resnet50-cuhk03-alignedreid --test_distance local (--reranking)
```
## 效果展示
<div align=center>
    <img src="imgs/Figure_1.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| ResNet50 | 96.8MB| K100AI | 1 | [下载地址](https://pan.baidu.com/s/1Zbx_K2Cm1cgUUTNYJRImMA) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/alignedreid_pytorch

## 参考资料
- https://github.com/michuanhaohao/AlignedReID
