# aiXcoder-7B  
## 论文
- https://arxiv.org/pdf/2410.13187
## 模型结构
aiXcoder-7B 是一个轻量级且高效的代码大语言模型，专为代码补全、生成和理解设计。支持多种编程语言，包括Python、Java、C/C++、JavaScript、TypeScript、HTML等，适用于多种开发场景。官方文档未完全公开其详细的模型结构超参数。可以参考huggingface上公布的配置参数。
  
## 算法原理
aiXcoder-7B 的性能归功于以下关键训练策略：

多目标训练（Multi-objective Training）：
- Next-Token Prediction (NTP)：模拟从头编写代码，预测下一个 token。
- Fill-in-the-Middle (FIM)：训练模型基于前后上下文预测中间代码片段，适合修改现有代码。
- Structured Fill-in-the-Middle (SFIM)：创新的训练目标，基于语法树选择完整代码片段（如函数、循环块）作为 middle，提高生成完整代码的能力。  

数据采样策略：
- 考虑文件间关系（如文件内容相似性、依赖关系、路径相似性），增强跨文件上下文理解。  

数据处理：
- 数据收集流程包括爬取、清洗、去重、代码质量检查和敏感信息移除，处理 2.8TB 自然语言数据和 3.5TB 源代码数据。
- 数据覆盖多种编程语言，确保多语言支持。

## 环境配置  
## 硬件需求  
DCU型号：K100_AI，节点数量：1台，卡数：1张。  
### Docker（方法一）
从[光源](https://www.sourcefind.cn/#/service-list)中拉取docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250521-fixpy-rocblas0521-beta2
```
创建容器并挂载目录进行开发：
```
docker run -it --name {name} --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v {}:{} {docker_image} /bin/bash
# 修改1 {name} 需要改为自定义名称  
# 修改2 {docker_image} 需要需要创建容器的对应镜像名称  
# 修改3 -v 挂载路径到容器指定路径
pip install -r requirements.txt
```
### Dockerfile（方法二）
```
cd docker
docker build --no-cache -t qwen2_5_coder:1.0 .
docker run -it --name {name} --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v {}:{} {docker_image} /bin/bash 
pip install -r requirements.txt
```
### Anaconda（方法三）
线上节点推荐使用conda进行环境配置。
创建python=3.10的conda环境并激活
```
conda create -n qwen2_5_coder python=3.10
conda activate qwen2_5_coder
```

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk25.04
python：python3.10
pytorch:2.4.1
torchvision:0.19.1
sentencepiece>=0.2.0
```
安装其他依赖包
```
pip install -r requirements.txt
```

下载预训练权重文件：[HuggingFace下载](https://huggingface.co/aiXcoder/aixcoder-7b-base)   
可以通过huggingface-cli下载，下载命令：   
```
pip install -U huggingface_hub
export HF_ENDPOINT=https://hf-mirror.com
huggingface-cli download --resume-download aiXcoder/aixcoder-7b-base  --local-dir aiXcoder/aixcoder-7b-base
```
## 数据集 
微调数据集：[bigcode/the-stack-smol](https://huggingface.co/datasets/bigcode/the-stack-smol)
可以通过huggingface-cli下载，下载命令：   
```
huggingface-cli download --repo-type dataset --resume-download bigcode/the-stack-smol --local-dir bigcode/the-stack-smol
```
百度网盘下载链接：  
通过网盘分享的文件：bigcode.zip  
链接: https://pan.baidu.com/s/1R2_UQMSfiTou7ckpzGhSRQ?pwd=1234 提取码: 1234
## 训练
```
# 注意：
accelerate launch finetune.py \
        --model_id "aiXcoder/aixcoder-7b-base" \
        --dataset_name "bigcode/the-stack-smol" \
        --subset "data/rust" \
        --dataset_text_field "content" \
        --split "train" \
        --max_seq_length 1024 \
        --max_steps 100 \
        --micro_batch_size 1 \
        --gradient_accumulation_steps 8 \
        --learning_rate 5e-6 \
        --warmup_steps 20 \
        --fim_rate 0.5 \
        --num_proc "$(nproc)"
```

## 推理
```
# 注意：修改为自己的模型路径
python sess_huggingface.py
```

## result
<div align=center>
    <img src="./assets/infer.png"/>
</div> 

## 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
代码生成

### 热点应用行业
代码生成

## 源码仓库及问题反馈
[https://developer.sourcefind.cn/codes/modelzoo/qwen2.5_coder](https://developer.sourcefind.cn/codes/dongchy920/qwen2.5_coder)
## 参考资料
[https://github.com/aixcoder-plugin/aiXcoder-7B](https://github.com/aixcoder-plugin/aiXcoder-7B)  


