# AASIST 
## 模型介绍
开源的音频反欺骗的模型

## 模型结构
aasist,参考链接https://github.com/clovaai/aasist， 参考论文ASIST: Audio Anti-Spoofing using Integrated Spectro-Temporal Graph Attention Networks

## 数据集
脚本下载方式：
python ./download_dataset.py
手动下载方式：
ASVspoof2019 dataset: https://datashare.ed.ac.uk/handle/10283/3336链接进行下载LA.zip文件
下载后unzip解压

## 推理

### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：
* 推理镜像：
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:aasist-main

激活镜像环境：

source /root/env_disc.sh
cd /root/aasist;sh run.sh

* python依赖安装：

pip3 install -r requirement.txt

### 推理命令,使用BladeDISC进行加速

To evaluate AASIST [1]:

export TORCH_MHLO_OP_WHITE_LIST="aten::max;aten::batch_norm;aten::abs,aten::selu;prim::NumToTensor;aten::zeros_like;aten::size;aten::narrow;aten::cat;aten::selu_"

python3 main.py --eval --config ./config/AASIST.conf
python3 main_opt.py --eval --config ./config/AASIST.conf


To evaluate AASIST-L [1]:

export TORCH_MHLO_OP_WHITE_LIST="aten::max;aten::batch_norm;aten::abs,aten::selu;prim::NumToTensor;aten::zeros_like;aten::size;aten::narrow;aten::cat;aten::selu_"

python3 main.py --eval --config ./config/AASIST-L.conf
python3 main_opt.py --eval --config ./config/AASIST-L.conf

### 单卡测试
测试命令：

bash run.sh

### 准确率验证

准确率验证通过对比优化前与优化后的输出结果,精度差异较小，判定准确率为正常的

## 历史版本
* https://developer.hpccube.com/codes/modelzoo/bladedisc_aasist

## 参考
* https://github.com/clovaai/aasist.git
