# AASIST 
## 模型介绍
是开源的音频反欺骗的模型

## 模型结构
aasist,参考链接https://github.com/clovaai/aasist， 参考论文ASIST: Audio Anti-Spoofing using Integrated Spectro-Temporal Graph Attention Networks

## AASIST代码参考版本

原始代码位置：https://github.com/clovaai/aasist.git

## 数据集
下载方式：
python ./download_dataset.py
或者可以手动从ASVspoof2019 dataset: https://datashare.ed.ac.uk/handle/10283/3336链接进行下载LA.zip文件
下载后unzip解压

## 推理

### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：
* 训练镜像：

python依赖安装：

pip3 install -r requirement.txt

### 推理命令,使用BladeDISC进行加速

To evaluate AASIST [1]:
export TORCH_MHLO_OP_WHITE_LIST="aten::max;aten::batch_norm;aten::abs,aten::selu;prim::NumToTensor;aten::zeros_like;aten::size;aten::narrow;aten::cat;aten::selu_"
python3 main.py --eval --config ./config/AASIST.conf
python3 main_opt.py --eval --config ./config/AASIST.conf


To evaluate AASIST-L [1]:
export TORCH_MHLO_OP_WHITE_LIST="aten::max;aten::batch_norm;aten::abs,aten::selu;prim::NumToTensor;aten::zeros_like;aten::size;aten::narrow;aten::cat;aten::selu_"
python3 main.py --eval --config ./config/AASIST-L.conf
python3 main_opt.py --eval --config ./config/AASIST-L.conf

### 单卡测试
测试命令：

bash run.sh
### 性能和准确率数据
性能测试以AASIST-L为例(记录每次推理的执行时间)：

case | 优化前(关闭disc) | 优化后(打开disc) | 性能提升 |
| :---- | ----: | :----: | ---- |
AASIST-L | 0.018s | 0.008s | 2.25倍

准确率测试通过对比优化前与优化后的输出结果,精度差异较小，判定准确率为正常的

## 参考
* https://github.com/clovaai/aasist.git
