# AASIST
## 模型介绍
开源的音频反欺骗的模型

## 论文
参考ASIST: Audio Anti-Spoofing using Integrated Spectro-Temporal Graph Attention Networks

## 模型结构
aasist是一种开源的音频反欺诈的模型，主要的模型结构如下所示：

![Aassist_Backbone](Aassist_Backbone.PNG)

## 环境配置
### Docker(方法一)
提供[光源](https://www.sourcefind.cn/#/service-list)拉取的训练的docker镜像：
* 推理镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:aasist-main
```
* 激活镜像环境：
```
source /root/env_disc.sh
cd /root/aasist;sh run.sh
```
* python依赖安装：
```
pip3 install -r requirement.txt
```

## 数据集

脚本下载方式：
```
python ./download_dataset.py
```
手动下载方式：
```
ASVspoof2019 dataset: https://datashare.ed.ac.uk/handle/10283/3336
```
下载LA.zip文件,unzip解压

## 推理

To evaluate AASIST [1]:
```
export TORCH_MHLO_OP_WHITE_LIST="aten::max;aten::batch_norm;aten::abs,aten::selu;prim::NumToTensor;aten::zeros_like;aten::size;aten::narrow;aten::cat;aten::selu_"

python3 main.py --eval --config ./config/AASIST.conf
python3 main_opt.py --eval --config ./config/AASIST.conf
```

To evaluate AASIST-L [1]:
```
export TORCH_MHLO_OP_WHITE_LIST="aten::max;aten::batch_norm;aten::abs,aten::selu;prim::NumToTensor;aten::zeros_like;aten::size;aten::narrow;aten::cat;aten::selu_"

python3 main.py --eval --config ./config/AASIST-L.conf
python3 main_opt.py --eval --config ./config/AASIST-L.conf
```

测试命令：
```
bash run.sh
```
## 精度
使用Blade DISC优化后的精度与未使用Blade DISC优化后的精度保持一致

## 应用场景
### 算法类别
语音识别

### 热点行业
金融,交通,教育

### 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/bladedisc_aasist

### 参考
https://github.com/clovaai/aasist.git

