class STFT(Module):
  __parameters__ = []
  __buffers__ = ["forward_basis_buffer", ]
  forward_basis_buffer : Tensor
  training : bool
  _is_full_backward_hook : Optional[bool]
  filter_length : int
  hop_length : int
  win_length : int
  window : str
  forward_transform : NoneType
  def forward(self: __torch__.vad.utils.pytorch_stft.___torch_mangle_1.STFT,
    input_data: Tensor) -> Tensor:
    _0 = ((self).transform_(input_data, ))[0]
    return _0
  def transform_(self: __torch__.vad.utils.pytorch_stft.___torch_mangle_1.STFT,
    input_data: Tensor) -> Tuple[Tensor, Tensor]:
    num_batches = torch.size(input_data, 0)
    num_samples = torch.size(input_data, 1)
    input_data0 = torch.view(input_data, [num_batches, 1, num_samples])
    filter_length = self.filter_length
    hop_length = self.hop_length
    _1 = torch.sub(filter_length, hop_length)
    to_pad = int(torch.div(_1, 2))
    input_data1 = torch.pad(torch.unsqueeze(input_data0, 1), [to_pad, to_pad, 0, 0], "reflect")
    input_data2 = torch.squeeze(input_data1, 1)
    forward_basis_buffer = self.forward_basis_buffer
    hop_length0 = self.hop_length
    forward_transform = torch.conv1d(input_data2, forward_basis_buffer, None, [hop_length0], [0])
    filter_length0 = self.filter_length
    _2 = torch.add(torch.div(filter_length0, 2), 1)
    cutoff = int(_2)
    _3 = torch.slice(torch.slice(forward_transform), 1, None, cutoff)
    real_part = torch.to(torch.slice(_3, 2), 6)
    _4 = torch.slice(torch.slice(forward_transform), 1, cutoff)
    imag_part = torch.to(torch.slice(_4, 2), 6)
    _5 = torch.add(torch.pow(real_part, 2), torch.pow(imag_part, 2))
    magnitude = torch.sqrt(_5)
    phase = torch.atan2(ops.prim.data(imag_part), ops.prim.data(real_part))
    return (magnitude, phase)
