class LSTM(Module):
  __parameters__ = ["weight_ih_l0", "weight_hh_l0", "bias_ih_l0", "bias_hh_l0", "weight_ih_l1", "weight_hh_l1", "bias_ih_l1", "bias_hh_l1", ]
  __buffers__ = []
  weight_ih_l0 : Tensor
  weight_hh_l0 : Tensor
  bias_ih_l0 : Tensor
  bias_hh_l0 : Tensor
  weight_ih_l1 : Tensor
  weight_hh_l1 : Tensor
  bias_ih_l1 : Tensor
  bias_hh_l1 : Tensor
  training : bool
  _is_full_backward_hook : NoneType
  _flat_weights_names : List[str]
  _all_weights : List[List[str]]
  _flat_weights : List[Tensor]
  bias : Final[bool] = True
  num_layers : Final[int] = 2
  batch_first : Final[bool] = True
  bidirectional : Final[bool] = False
  hidden_size : Final[int] = 64
  proj_size : Final[int] = 0
  input_size : Final[int] = 64
  dropout : Final[float] = 0.10000000000000001
  mode : Final[str] = "LSTM"
  def forward__0(self: __torch__.torch.nn.modules.rnn.LSTM,
    input: Tensor,
    hx: Optional[Tuple[Tensor, Tensor]]=None) -> Tuple[Tensor, Tuple[Tensor, Tensor]]:
    _0 = "For batched 3-D input, hx and cx should also be 3-D but got ({}-D, {}-D) tensors"
    _1 = "For unbatched 2-D input, hx and cx should also be 2-D but got ({}-D, {}-D) tensors"
    is_batched = torch.eq(torch.dim(input), 3)
    if torch.__not__(is_batched):
      input0 = torch.unsqueeze(input, 0)
    else:
      input0 = input
    max_batch_size = torch.size(input0, 0)
    if torch.__is__(hx, None):
      _2 = ops.prim.dtype(input0)
      _3 = ops.prim.device(input0)
      h_zeros = torch.zeros([2, max_batch_size, 64], dtype=_2, layout=None, device=_3)
      _4 = ops.prim.dtype(input0)
      _5 = ops.prim.device(input0)
      c_zeros = torch.zeros([2, max_batch_size, 64], dtype=_4, layout=None, device=_5)
      hx0 = (h_zeros, c_zeros)
    else:
      hx1 = unchecked_cast(Tuple[Tensor, Tensor], hx)
      if is_batched:
        _6 = torch.ne(torch.dim((hx1)[0]), 3)
        if _6:
          _7 = True
        else:
          _8 = torch.ne(torch.dim((hx1)[1]), 3)
          _7 = _8
        if _7:
          msg = torch.format(_0, torch.dim((hx1)[0]), torch.dim((hx1)[1]))
          ops.prim.RaiseException(msg, "builtins.RuntimeError")
        else:
          pass
        hx2 = hx1
      else:
        _9 = torch.ne(torch.dim((hx1)[0]), 2)
        if _9:
          _10 = True
        else:
          _11 = torch.ne(torch.dim((hx1)[1]), 2)
          _10 = _11
        if _10:
          msg0 = torch.format(_1, torch.dim((hx1)[0]), torch.dim((hx1)[1]))
          ops.prim.RaiseException(msg0, "builtins.RuntimeError")
        else:
          pass
        hx3 = (torch.unsqueeze((hx1)[0], 1), torch.unsqueeze((hx1)[1], 1))
        hx2 = hx3
      hx4 = (self).permute_hidden(hx2, None, )
      hx0 = hx4
    _12 = (self).check_forward_args(input0, hx0, None, )
    _flat_weights = self._flat_weights
    training = self.training
    _13, _14, = hx0
    _15, _16, _17 = torch.lstm(input0, [_13, _14], _flat_weights, True, 2, 0.10000000000000001, training, False, True)
    hidden = (_16, _17)
    if torch.__not__(is_batched):
      output0 = torch.squeeze(_15, 0)
      hidden1 = (torch.squeeze(_16, 1), torch.squeeze(_17, 1))
      hidden0, output = hidden1, output0
    else:
      hidden0, output = hidden, _15
    _18 = (self).permute_hidden(hidden0, None, )
    return (output, _18)
  def forward__1(self: __torch__.torch.nn.modules.rnn.LSTM,
    input: __torch__.torch.nn.utils.rnn.PackedSequence,
    hx: Optional[Tuple[Tensor, Tensor]]=None) -> Tuple[__torch__.torch.nn.utils.rnn.PackedSequence, Tuple[Tensor, Tensor]]:
    input1, batch_sizes, sorted_indices, unsorted_indices, = input
    max_batch_size = torch.select(batch_sizes, 0, 0)
    max_batch_size0 = int(max_batch_size)
    if torch.__is__(hx, None):
      _19 = ops.prim.dtype(input1)
      _20 = ops.prim.device(input1)
      h_zeros = torch.zeros([2, max_batch_size0, 64], dtype=_19, layout=None, device=_20)
      _21 = ops.prim.dtype(input1)
      _22 = ops.prim.device(input1)
      c_zeros = torch.zeros([2, max_batch_size0, 64], dtype=_21, layout=None, device=_22)
      hx5 = (h_zeros, c_zeros)
    else:
      hx6 = unchecked_cast(Tuple[Tensor, Tensor], hx)
      hx7 = (self).permute_hidden(hx6, sorted_indices, )
      hx5 = hx7
    _23 = (self).check_forward_args(input1, hx5, batch_sizes, )
    _flat_weights = self._flat_weights
    training = self.training
    _24, _25, = hx5
    _26, _27, _28 = torch.lstm(input1, batch_sizes, [_24, _25], _flat_weights, True, 2, 0.10000000000000001, training, False)
    hidden = (_27, _28)
    output_packed = __torch__.torch.nn.utils.rnn.PackedSequence(_26, batch_sizes, sorted_indices, unsorted_indices)
    _29 = (self).permute_hidden(hidden, unsorted_indices, )
    return (output_packed, _29)
  def permute_hidden(self: __torch__.torch.nn.modules.rnn.LSTM,
    hx: Tuple[Tensor, Tensor],
    permutation: Optional[Tensor]) -> Tuple[Tensor, Tensor]:
    _30 = __torch__.torch.nn.modules.rnn.apply_permutation
    if torch.__is__(permutation, None):
      _31 = hx
    else:
      permutation0 = unchecked_cast(Tensor, permutation)
      _32 = (_30((hx)[0], permutation0, 1, ), _30((hx)[1], permutation0, 1, ))
      _31 = _32
    return _31
  def check_forward_args(self: __torch__.torch.nn.modules.rnn.LSTM,
    input: Tensor,
    hidden: Tuple[Tensor, Tensor],
    batch_sizes: Optional[Tensor]) -> NoneType:
    _33 = "Expected hidden[0] size {}, got {}"
    _34 = "Expected hidden[1] size {}, got {}"
    _35 = (self).check_input(input, batch_sizes, )
    _36 = (hidden)[0]
    _37 = (self).get_expected_hidden_size(input, batch_sizes, )
    _38 = (self).check_hidden_size(_36, _37, _33, )
    _39 = (hidden)[1]
    _40 = (self).get_expected_cell_size(input, batch_sizes, )
    _41 = (self).check_hidden_size(_39, _40, _34, )
    return None
  def check_input(self: __torch__.torch.nn.modules.rnn.LSTM,
    input: Tensor,
    batch_sizes: Optional[Tensor]) -> NoneType:
    _42 = "input must have {} dimensions, got {}"
    _43 = "input.size(-1) must be equal to input_size. Expected {}, got {}"
    if torch.__isnot__(batch_sizes, None):
      expected_input_dim = 2
    else:
      expected_input_dim = 3
    _44 = torch.ne(torch.dim(input), expected_input_dim)
    if _44:
      _45 = torch.format(_42, expected_input_dim, torch.dim(input))
      ops.prim.RaiseException(_45, "builtins.RuntimeError")
    else:
      pass
    if torch.ne(64, torch.size(input, -1)):
      _46 = torch.format(_43, 64, torch.size(input, -1))
      ops.prim.RaiseException(_46, "builtins.RuntimeError")
    else:
      pass
    return None
  def check_hidden_size(self: __torch__.torch.nn.modules.rnn.LSTM,
    hx: Tensor,
    expected_hidden_size: Tuple[int, int, int],
    msg: str="Expected hidden size {}, got {}") -> NoneType:
    _47 = torch.size(hx)
    _48, _49, _50, = expected_hidden_size
    if torch.ne(_47, [_48, _49, _50]):
      _51 = torch.format(msg, expected_hidden_size, torch.list(torch.size(hx)))
      ops.prim.RaiseException(_51, "builtins.RuntimeError")
    else:
      pass
    return None
  def get_expected_hidden_size(self: __torch__.torch.nn.modules.rnn.LSTM,
    input: Tensor,
    batch_sizes: Optional[Tensor]) -> Tuple[int, int, int]:
    if torch.__isnot__(batch_sizes, None):
      batch_sizes0 = unchecked_cast(Tensor, batch_sizes)
      mini_batch0 = int(torch.select(batch_sizes0, 0, 0))
      mini_batch = mini_batch0
    else:
      mini_batch = torch.size(input, 0)
    return (2, mini_batch, 64)
  def get_expected_cell_size(self: __torch__.torch.nn.modules.rnn.LSTM,
    input: Tensor,
    batch_sizes: Optional[Tensor]) -> Tuple[int, int, int]:
    if torch.__isnot__(batch_sizes, None):
      batch_sizes1 = unchecked_cast(Tensor, batch_sizes)
      mini_batch1 = int(torch.select(batch_sizes1, 0, 0))
      mini_batch = mini_batch1
    else:
      mini_batch = torch.size(input, 0)
    return (2, mini_batch, 64)
def apply_permutation(tensor: Tensor,
    permutation: Tensor,
    dim: int=1) -> Tensor:
  _52 = torch.index_select(tensor, dim, permutation)
  return _52
