def relu(input: Tensor,
    inplace: bool=False) -> Tensor:
  if inplace:
    result = torch.relu_(input)
  else:
    result = torch.relu(input)
  return result
def dropout(input: Tensor,
    p: float=0.5,
    training: bool=True,
    inplace: bool=False) -> Tensor:
  _0 = "dropout probability has to be between 0 and 1, but got {}"
  if torch.lt(p, 0.):
    _1 = True
  else:
    _1 = torch.gt(p, 1.)
  if _1:
    ops.prim.RaiseException(torch.format(_0, p), "builtins.ValueError")
  else:
    pass
  if inplace:
    _2 = torch.dropout_(input, p, training)
  else:
    _2 = torch.dropout(input, p, training)
  return _2
def batch_norm(input: Tensor,
    running_mean: Optional[Tensor],
    running_var: Optional[Tensor],
    weight: Optional[Tensor]=None,
    bias: Optional[Tensor]=None,
    training: bool=False,
    momentum: float=0.10000000000000001,
    eps: float=1.0000000000000001e-05) -> Tensor:
  _3 = __torch__.torch.nn.functional._verify_batch_size
  if training:
    _4 = _3(torch.size(input), )
  else:
    pass
  _5 = torch.batch_norm(input, weight, bias, running_mean, running_var, training, momentum, eps, True)
  return _5
def _verify_batch_size(size: List[int]) -> NoneType:
  _6 = "Expected more than 1 value per channel when training, got input size {}"
  size_prods = size[0]
  size_prods0 = size_prods
  for i in range(torch.sub(torch.len(size), 2)):
    size_prods1 = torch.mul(size_prods0, size[torch.add(i, 2)])
    size_prods0 = size_prods1
  if torch.eq(size_prods0, 1):
    ops.prim.RaiseException(torch.format(_6, size), "builtins.ValueError")
  else:
    pass
  return None
