class BatchNorm1d(Module):
  __parameters__ = ["weight", "bias", ]
  __buffers__ = ["running_mean", "running_var", "num_batches_tracked", ]
  weight : Tensor
  bias : Tensor
  running_mean : Tensor
  running_var : Tensor
  num_batches_tracked : Tensor
  training : bool
  _is_full_backward_hook : NoneType
  affine : Final[bool] = True
  eps : Final[float] = 1.0000000000000001e-05
  momentum : Final[float] = 0.10000000000000001
  track_running_stats : Final[bool] = True
  num_features : Final[int] = 64
  def forward(self: __torch__.torch.nn.modules.batchnorm.___torch_mangle_23.BatchNorm1d,
    input: Tensor) -> Tensor:
    _0 = __torch__.torch.nn.functional.batch_norm
    _1 = (self)._check_input_dim(input, )
    training = self.training
    if training:
      num_batches_tracked = self.num_batches_tracked
      _2 = torch.add_(num_batches_tracked, 1)
    else:
      pass
    training0 = self.training
    if training0:
      bn_training = True
    else:
      bn_training = False
    running_mean = self.running_mean
    running_var = self.running_var
    weight = self.weight
    bias = self.bias
    _3 = _0(input, running_mean, running_var, weight, bias, bn_training, 0.10000000000000001, 1.0000000000000001e-05, )
    return _3
  def _check_input_dim(self: __torch__.torch.nn.modules.batchnorm.___torch_mangle_23.BatchNorm1d,
    input: Tensor) -> NoneType:
    _4 = "expected 2D or 3D input (got {}D input)"
    if torch.ne(torch.dim(input), 2):
      _5 = torch.ne(torch.dim(input), 3)
    else:
      _5 = False
    if _5:
      _6 = torch.format(_4, torch.dim(input))
      ops.prim.RaiseException(_6, "builtins.ValueError")
    else:
      pass
    return None
