# TeleChat

## 论文

https://arxiv.org/abs/2401.03804

## 模型结构

采用标准的 `Decoder-only` 结构设计了 **TeleChat** 模型，并在模型维度做了如下的一些改进：

- **位置编码**：使用 [Rotary Embedding](https://arxiv.org/pdf/2104.09864.pdf) 的位置编码方法，该方法将相对位置信息依赖集成到 self-attention 中，并且具有较好的位置外推性。Rotary Embedding还可以较好地与Flash-Attention v2 配合使用，将模型的训练速度提升约20%。
- **激活函数**：使用 [SwiGLU](https://arxiv.org/pdf/2002.05202.pdf) 激活函数来替代GELU激活函数 , 为了减少计算量，将`ffn_hidden_size`设置为小于原始SwiGLU中的4倍隐藏层大小。
- **层标准化**: 基于 [RMSNorm](https://arxiv.org/abs/1910.07467) 的 Pre-Normalization。
- **词嵌入层与输出层解耦**：将**TeleChat-12B**的词嵌入层和输出lm head层参数分开，有助于增强训练稳定性和收敛性。

|      | layer_num | hidden_size | ffn_hidden_size | head_num | tie_word_embeddings |
| ---- | --------- | ----------- | --------------- | -------- | ------------------- |
| 1B   | 16        | 2048        | 5460            | 32       | 否                  |
| 7B   | 30        | 4096        | 12288           | 32       | 是                  |
| 12B  | 38        | 5120        | 12288           | 32       | 否                  |

## 算法原理
TeleChat 是一个基于 Transformer 架构的语义大模型，拥有千亿级别的参数量。它采用了先进的预训练技术，通过对大量高质量文本数据的学习，使得模型具备了强大的语义理解和生成能力。在模型结构上，TeleChat 借鉴了GPT等生成式预训练模型的成功经验，同时结合了中国电信的实际需求进行了优化，从而实现了更高的性能和更广泛的应用场景。
## 环境配置

### Docker（方法一）

```
拉取镜像：
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

创建并启动容器：
docker run --shm-size 80g --network=host --name=telechat --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined  -v /opt/hyhal:/opt/hyhal:ro -v <Host Path>:<Container Path> -it <Your Image ID> bash

安装依赖：
cd TeleChat
pip install -r requirements.txt -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install 'ms-swift[llm]' -U -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install optimum -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install auto-gptq -i https://pypi.mirrors.ustc.edu.cn/simple/
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
cd TeleChat/docker
docker build --no-cache -t telechat_pytorch:latest .
docker run --shm-size 80g --network=host --name=telechat --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined  -v /opt/hyhal:/opt/hyhal:ro -v <Host Path>:<Container Path> -it telechat_pytorch:latest bash

安装依赖：
cd TeleChat
pip install -r requirements.txt -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install 'ms-swift[llm]' -U -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install optimum -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install auto-gptq -i https://pypi.mirrors.ustc.edu.cn/simple/
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04.1
python:python3.10
torch:2.1.0
torchvision:0.16.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非深度学习库参照requirements.txt安装：
```
安装依赖：
cd TeleChat
pip install -r requirements.txt -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install 'ms-swift[llm]' -U -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install optimum -i https://pypi.mirrors.ustc.edu.cn/simple/
pip install auto-gptq -i https://pypi.mirrors.ustc.edu.cn/simple/
```

## 数据集
无
## 模型下载链接

| **模型版本** | **下载链接**                                                 |
| ------------ | ------------------------------------------------------------ |
| 7B-FP16      | [TeleChat-7B](https://huggingface.co/Tele-AI/telechat-7B) |
| 12B-V2-FP16  | [TeleChat-12B-V2-FP16](https://huggingface.co/Tele-AI/TeleChat-12B-v2) |


## 推理

### TeleChat-7B
进入Telechat/inference_telechat

```
bash infer.sh
```

### TeleChat-12B/TeleChat-12B-V2

修改模型文件路径里面的config.json，把flash_attn改为false

进入Telechat/inference_telechat

```
bash infer.sh
```

## 训练
```
cd Telechat/ms-swift/examples/pytorch/llm
```
### 单机单卡LORA微调训练

```
bash sft_single_lora.sh
```

### 单机多卡LORA微调训练

```
bash sft_multi_lora.sh
```

### 单机多卡全参微调训练

```
bash sft_multi_full.sh
```

### 训练后的推理

```
与微调训练同文件夹下
bash infer.sh
```

## result
![推理1](推理1.png)
### 精度
无


## 量化
### GPTQ量化
/usr/local/lib/python3.10/site-packages/optimum/gptq/quantizer.py 找到这个文件，676行，把safe_serialization=False
```
HIP_VISIBLE_DEVICES=0 swift export --model_type telechat-7b \
    --quant_bits 8 --quant_method gptq --model_id_or_path /path/to/telechat-7b \
    --quant_output_dir ./quant_out
```


### 量化后推理

```
HSA_FORCE_FINE_GRAIN_PCIE=1 swift infer --model_type telechat-7b --model_id_or_path quant_out/
```

![推理2](推理2.png)

## 应用场景
### 算法类别
LLM
### 热点应用行业
运营商、科研、教育

## 源码仓库及问题反馈
https://developer.sourcefind.cn/codes/modelzoo/Telechat_pytorch/-/tree/master

## 参考资料

https://github.com/Tele-AI/Telechat/tree/master 


https://github.com/modelscope/ms-swift

