# 命令行参数

## 目录

- [sft 参数](#sft-参数)
- [pt 参数](#pt-参数)
- [rlhf 参数](#rlhf-参数)
- [infer merge-lora 参数](#infer-merge-lora-参数)
- [export 参数](#export-参数)
- [eval参数](#eval参数)
- [app-ui 参数](#app-ui-参数)
- [deploy 参数](#deploy-参数)

## sft 参数

- `--model_type`: 表示你选择的模型类型, 默认是`None`. `model_type`指定了对应模型默认的`target_modules`, `template_type`等信息. 你可以通过只指定`model_type`进行微调. 对应的`model_id_or_path`会使用默认的设置, 从ModelScope进行下载, 并使用默认的缓存路径. model_type和model_id_or_path必须指定其中的一个. 可以选择的`model_type`可以查看[支持的模型](支持的模型和数据集.md#模型). 你可以设置`USE_HF`环境变量来控制从HF Hub下载模型和数据集, 参考[HuggingFace生态兼容文档](HuggingFace生态兼容.md).
- `--model_id_or_path`: 表示模型在ModelScope/HuggingFace Hub中的`model_id`或者本地路径, 默认为`None`. 如果传入的`model_id_or_path`已经被注册, 则会根据`model_id_or_path`推断出`model_type`. 如果未被注册, 则需要同时指定`model_type`, e.g. `--model_type <model_type> --model_id_or_path <model_id_or_path>`.
- `--model_revision`: 表示模型在ModelScope Hub中对应`model_id`的版本号, 默认为`None`. `model_revision`指定为`None`, 则使用注册在`MODEL_MAPPING`中的revision. 否则强制使用命令行传入的`model_revision`.
- `--local_repo_path`: 部分模型在加载时依赖于github repo. 为了避免`git clone`时遇到网络问题, 可以直接使用本地repo. 该参数需要传入本地repo的路径, 默认为`None`. 这部分模型包括:
  - mPLUG-Owl模型: `https://github.com/X-PLUG/mPLUG-Owl`
  - DeepSeek-VL模型: `https://github.com/deepseek-ai/DeepSeek-VL`
  - YI-VL模型: `https://github.com/01-ai/Yi`
  - LLAVA模型: `https://github.com/haotian-liu/LLaVA.git`
- `--sft_type`: 表示微调的方式, 默认是`'lora'`. 你可以选择的值包括: 'lora', 'full', 'longlora', 'adalora', 'ia3', 'llamapro', 'adapter', 'vera', 'boft', 'fourierft'. 如果你要使用qlora, 你需设置`--sft_type lora --quantization_bit 4`.
- `--packing`: pack数据集到`max-length`, 默认值`False`.
- `--full_determinism`: 固定所有的随机性, 默认值`False`.
- `--auto_find_batch_size`: 根据显存值自定找到batch_size, 默认值`False`.
- `--streaming`: 是否使用流式数据处理, 默认值`False`.
- `--freeze_parameters`: 当sft_type指定为'full'时, 将模型最底部的参数进行freeze. 指定范围为0. ~ 1., 默认为`0.`. 该参数提供了lora与全参数微调的折中方案.
- `--additional_trainable_parameters`: 作为freeze_parameters的补充, 只有在sft_type指定为'full'才允许被使用, 默认为`[]`. 例如你如果想训练50%的参数的情况下想额外训练embedding层, 你可以设置`--freeze_parameters 0.5 --additional_trainable_parameters transformer.wte`, 所有以`transformer.wte`开头的parameters都会被激活. 你也可以设置`--freeze_parameters 1 --additional_trainable_parameters xxx`来自定义可以训练的层.
- `--tuner_backend`: 表示lora, qlora的后端支持, 默认是`'peft'`. 你可以选择的值包括: 'swift', 'peft', 'unsloth'.
- `--template_type`: 表示使用的对话模板的类型, 默认是`'AUTO'`, 即根据`model_type`查找`MODEL_MAPPING`中的`template`. 可以选择的`template_type`可以查看`TEMPLATE_MAPPING.keys()`.
- `--output_dir`: 表示ckpt存储的目录, 默认是`'output'`. 我们会在该目录后拼接`model_type`和微调版本号. 方便用户对不同模型进行多次对比实验, 而不需要改变`output_dir`命令行参数. 如果不需要拼接这些内容, 你需要额外指定参数`--add_output_dir_suffix false`.
- `--add_output_dir_suffix`: 默认为`True`, 表示会在`output_dir`的目录后拼接上`model_type`和微调版本号的后缀. 如果要避免此行为, 你可以设置为`False`.
- `--ddp_backend`: 表示分布式的后端支持, 默认是`None`. 你可以选择的值包括: 'nccl', 'gloo', 'mpi', 'ccl'.
- `--seed`: 全局的seed, 默认使用`42`. 用于复现训练效果.
- `--resume_from_checkpoint`: 用于断点续训, 默认为`None`. 你可以将其设置为checkpoint的路径, 例如: `--resume_from_checkpoint output/qwen-7b-chat/vx-xxx/checkpoint-xxx`, 来进行断点续训. 支持调节`--resume_only_model`在断点续训时只读取模型文件.
- `--resume_only_model`: 默认为`False`, 即为严格的断点续训, 这会读取模型、优化器和lr_scheduler的权重和各个设备存储的随机种子, 并将从上次训练暂停的stpes后继续计数进行训练. 如果设置为`True`, 则只读取模型的权重.
- `--dtype`: 基模型载入时的torch_dtype, 默认为`'AUTO'`, 即智能选择dtype: 如果机器不支持bf16, 则使用fp16, 如果`MODEL_MAPPING`中对应模型有指定torch_dtype, 则使用其对应dtype, 否则使用bf16. 你可以选择的值包括: 'bf16', 'fp16', 'fp32'.
- `--dataset`: 用于选择训练的数据集, 默认为`[]`. 可以选择的数据集可以查看[支持的数据集](支持的模型和数据集.md#数据集). 如果需要使用多个数据集进行训练, 你可以使用','或者' '进行分割, 例如: `--dataset alpaca-en,alpaca-zh` or `--dataset alpaca-en alpaca-zh`. 支持Modelscope Hub/HuggingFace Hub/本地路径、subsets选择与数据集采样, 每个数据集指定格式如下: `[HF or MS::]{dataset_name} or {dataset_id} or {dataset_path}[:subset1/subset2/...][#dataset_sample]`, 最简只需要指定dataset_name、dataset_id或者dataset_path即可. 自定义数据集可以查看[数据集的自定义与拓展文档](自定义与拓展.md#自定义数据集).
   - 支持MS和HF hub, 以及dataset_sample的支持. e.g. 'MS::alpaca-zh#2000', 'HF::jd-sentiment-zh#2000' (默认使用的hub, 由`USE_UF`环境变量控制, 默认MS).
   - 对subsets更细粒度的控制: 默认使用注册时指定的subsets(注册时未指定则使用'default'). e.g. 'sharegpt-gpt4'. 如果指定subsets则使用对应子集的数据集. e.g. 'sharegpt-gpt4:default/V3_format#2000'. 使用'/'进行分隔.
   - dataset_id的支持. e.g. 'AI-ModelScope/alpaca-gpt4-data-zh#2000', 'HF::llm-wizard/alpaca-gpt4-data-zh#2000', 'hurner/alpaca-gpt4-data-zh#2000', 'HF::shibing624/alpaca-zh#2000'. 如果dataset_id已经注册，则会使用注册时的预处理函数、subsets、split等. 否则使用`SmartPreprocessor`, 支持5种数据集格式, 并使用'default'的subsets, split设置为'train'. 支持的数据集格式可以查看[数据集的自定义与拓展文档](自定义与拓展.md#自定义数据集).
   - dataset_path的支持. e.g. '1.jsonl#5000'. (如果是相对路径，则为相对于运行目录的相对路径).
- `--val_dataset`: 用于指定单独的验证集, 格式和`dataset`参数相同, 默认为`[]`. 如果使用本参数, 则`dataset_test_ratio`不再生效.
- `--dataset_seed`: 用于指定数据集处理的seed, 默认为`None`, 即指定为全局`seed`. dataset_seed以random_state形式存在, 不影响全局seed.
- `--dataset_test_ratio`: 用于指定子数据集切分成训练集和验证集的比例, 默认为`0.01`. 若设置了`--val_dataset`, 则该参数失效.
- `--train_dataset_sample`: 对训练集的采样数, 默认是`-1`, 即使用完整的训练集进行训练. 该参数已废弃, 请使用`--dataset {dataset_name}#{dataset_sample}`
- `--val_dataset_sample`: 对验证集进行采样, 默认是`None`, 自动选取合适数量的数据集数量进行验证. 如果你指定为`-1`, 则使用完整的验证集进行验证. 该参数已废弃, 验证集数量由`--dataset_test_ratio`或者`--val_dataset {dataset_name}#{dataset_sample}`控制.
- `--system`: 对话模板中使用的system, 默认为`None`, 即使用模型默认的system. 如果指定为'', 则不使用system.
- `--tools_prompt`: 选择tools字段转化的相应tools system prompt, 可选项为['react_en','react_zh', 'toolbench'], 分别为英文版ReAct格式，中文版ReAct格式和toolbench格式，默认为英文版ReAct格式。如果你想了解更多，可以参考[Agent部署最佳实践](Agent部署最佳实践.md)
- `--max_length`: token的最大长度, 默认为`2048`. 可以避免个别过长的数据样本造成OOM的问题. 当指定`--truncation_strategy delete`时, 如果某数据样本长度超过max_length, 我们会删除该数据样本. 如果指定`--truncation_strategy truncation_left`时, 我们会切除最前面的token: `input_ids[-max_length:]`. 如果设置为-1, 则无限制.
- `--truncation_strategy`: 默认是`'delete'`表示把超过max_length的句子从数据集中删除. `'truncation_left'`表示会将超过文本的左边给切除掉, 这可能会切到special token, 会影响性能, 并不推荐.
- `--check_dataset_strategy`: 默认值为`'none'`, 即不做检查. 如果你训练的模型是LLM, 则推荐使用`'warning'`作为数据检查的策略. 如果你的训练目标为句子分类等任务, 则建议设置为'`none`'.
- `--custom_train_dataset_path`: 默认值为`[]`. 该参数已废弃, 请使用`--dataset {dataset_path}`.
- `--custom_val_dataset_path`: 默认值为`[]`. 该参数已废弃, 该参数已废弃. 请使用`--val_dataset {dataset_path}`.
- `--self_cognition_sample`: 自我认知数据集的采样数. 默认为`0`. 你该值设置为>0时, 需要同时指定`--model_name`, `--model_author`. 该参数已废弃, 请使用`--dataset self-cognition#{self_cognition_sample}`.
- `--model_name`: 默认为`[None, None]`. 如果开启了自我认知数据集的采样(即指定`--dataset self-cognition`或者self_cognition_sample>0), 你需要传入两个值, 分别代表模型的中文名和英文名. 例如: `--model_name 小黄 'Xiao Huang'`. 如果你想了解更多, 可以查看[自我认知微调最佳实践](自我认知微调最佳实践.md).
- `--model_author`: 默认为`[None, None]`. 如果开启了自我认知数据集的采样, 你需要传入两个值, 分别代表作者的中文名和英文名. 例如: `--model_author 魔搭 ModelScope`.
- `--quant_method`: 量化方法, 默认为`None`. 你可以选择为'bnb', 'hqq', 'eetq'.
- `--quantization_bit`: 用于指定是否进行量化和量化的bit数, 默认为`0`, 即不进行量化. 如果要使用4bit qlora, 你需要设置`--sft_type lora --quantization_bit 4`
- `--hqq_axis`: hqq量化参数，表示执行分组的所沿的轴，默认为`0`, 可选值包括`0`,`1`
- `--hqq_dynamic_config_path`: hqq本地配置路径，支持对模型不同层配置不同的量化配置，[参考](https://github.com/mobiusml/hqq?tab=readme-ov-file#custom-quantization-configurations-%EF%B8%8F)
- `--bnb_4bit_comp_dtype`: 在进行4bit量化时, 我们需要在模型的forward和backward时, 将其进行反量化. 该参数用于指定反量化后的torch_dtype. 默认为`'AUTO'`, 即与`dtype`保持一致. 可选择的值包括: 'fp16', 'bf16', 'fp32'. 当quantization_bit为0时, 该参数无效.
- `--bnb_4bit_quant_type`: 4bit量化时的量化方式, 默认是`'nf4'`. 可选择的值包括: 'nf4', 'fp4'. 当quantization_bit为0时, 该参数无效.
- `--bnb_4bit_use_double_quant`: 是否在4bit量化时开启double量化, 默认为`True`. 当quantization_bit为0时, 该参数无效.
- `--bnb_4bit_quant_storage`: 默认值为`None`. 量化参数的存储类型. 若`quantization_bit`设置为0, 则该参数失效.
- `--target_modules`: 指定lora模块, 默认为`['DEFAULT']`. 如果target_modules传入`'DEFAULT'` or `'AUTO'`, 则根据`model_type`查找`MODEL_MAPPING`中的`target_modules`(LLM默认指定为qkv, MLLM默认为llm和projector中所有的linear). 如果传入`'ALL'`, 则将所有的Linear层(不含head)指定为lora模块. 如果传入`'EMBEDDING'`, 则Embedding层指定为lora模块. 如果内存允许, 建议设置成'ALL'. 当然, 你也可以设置`['ALL', 'EMBEDDING']`, 将所有的Linear和embedding层指定为lora模块. 该参数在使用lora/vera/boft/ia3/adalora/fourierft时生效.
- `--target_regex`: 指定lora模块的regex表达式, `Optional[str]`类型. 默认为`None`, 如果该值传入, 则target_modules不生效.该参数在使用lora/vera/boft/ia3/adalora/fourierft时生效.
- `--lora_rank`: 默认为`8`. 只有当`sft_type`指定为'lora'时才生效.
- `--lora_alpha`: 默认为`32`. 只有当`sft_type`指定为'lora'时才生效.
- `--lora_dropout`: 默认为`0.05`, 只有当`sft_type`指定为'lora'时才生效.
- `--init_lora_weights`: 初始化LoRA weights的方法, 可以指定为`true`, `false`, `guassian`, `pissa`, `pissa_niter_[number of iters]`, 默认值`true`.
- `--lora_bias_trainable`: 默认为`'none'`, 可以选择的值: 'none', 'all'. 如果你要将bias全都设置为可训练, 你可以设置为`'all'`.
- `--modules_to_save`: 默认为`[]`. 如果你想要训练embedding, lm_head, 或者layer_norm, 你可以设置此参数, 例如: `--modules_to_save EMBEDDING LN lm_head`. 如果传入`'EMBEDDING'`, 则将Embedding层添加到`modules_to_save`. 如果传入`'LN'`, 则将`RMSNorm`和`LayerNorm`添加到`modules_to_save`.该参数在使用lora/vera/boft/ia3/adalora/fourierft时生效.
- `--lora_dtype`: 默认为`'AUTO'`, 指定lora模块的dtype类型. 如果是`AUTO`则跟随原始模块的dtype类型. 你可以选择的值: 'fp16', 'bf16', 'fp32', 'AUTO'.
- `--use_dora`: 默认为`False`, 是否使用`DoRA`.
- `--use_rslora`: 默认为`False`, 是否使用`RS-LoRA`.
- `--neftune_noise_alpha`: `NEFTune`添加的噪声系数, 可以提升模型在指令微调中的性能, 默认为`None`. 通常可以设置为5, 10, 15. 你可以查看[相关论文](https://arxiv.org/abs/2310.05914).
- `--neftune_backend`: `NEFTune`的backend，默认使用`transformers`库, 当训练VL模型时可能遇到不适配的情况, 此时建议指定为`swift`.
- `--gradient_checkpointing`: 是否开启gradient checkpointing, 默认为`True`. 该参数可以用于节约显存, 虽然这会略微降低训练速度. 该参数在max_length较大, batch_size较大时作用显著.
- `--deepspeed`: 用于指定deepspeed的配置文件的路径或者直接传入json格式的配置信息, 默认为`None`, 即不开启deepspeed. deepspeed可以节约显存. 我们书写了默认的[ZeRO-2配置文件](https://github.com/modelscope/swift/blob/main/swift/llm/ds_config/zero2.json), [ZeRO-3配置文件](https://github.com/modelscope/swift/blob/main/swift/llm/ds_config/zero3.json). 你只需要指定'default-zero2', 就会使用默认zero2配置文件; 指定'default-zero3', 就会使用默认的zero3配置文件.
- `--batch_size`: 训练时的batch_size, 默认为`1`. 增大batch_size可以增加GPU的利用率, 但不一定会增加训练速度, 因为在一个batch中, 需要对较短的句子按该batch中最长句子的长度进行padding, 从而引入无效的计算量.
- `--eval_batch_size`: 评估时的batch_size, 默认为`None`, 即当`predict_with_generate`为True时, 设置为1, 为False时, 设置为`batch_size`.
- `--num_train_epochs`: 训练的epoch数, 默认为`1`. 如果`max_steps >= 0`, 则覆盖`num_train_epochs`. 你可以设置为3, 5, 10等.
- `--max_steps`: 训练的max_steps数, 默认为`-1`. 如果`max_steps >= 0`, 则覆盖`num_train_epochs`.
- `--optim`: 默认为`'adamw_torch'`.
- `--adam_beta1`: 默认为`0.9`.
- `--adam_beta2`: 默认为`0.95`.
- `--adam_epsilon`: 默认为`1e-8`.
- `--learning_rate`: 默认值为`None`, 即如果`sft_type`为lora, 则设置为1e-4, 如果`sft_type`为full, 则设置为1e-5.
- `--weight_decay`: 默认值为`0.1`.
- `--gradient_accumulation_steps`: 梯度累加, 默认值为`None`, 设置为`math.ceil(16 / self.batch_size / world_size)`. `total_batch_size =  batch_size * gradient_accumulation_steps * world_size`.
- `--max_grad_norm`: 梯度裁剪, 默认值为`1`.
- `--predict_with_generate`: 评估时是否使用生成式的方式, 默认为`False`. 如果设置为False, 则使用`loss`进行评估. 如果设置为True, 则使用`ROUGE-L`等指标进行评估. 使用生成式评估耗费的时间很长, 请谨慎选择.
- `--lr_scheduler_type`: 默认值为`'cosine'`, 你可以选择: 'linear', 'cosine', 'constant'等.
- `--warmup_ratio`: warmup占用总的训练steps的比例, 默认为`0.05`.
- `--warmup_steps`: warmup的步数, 默认为`0`. 如果设置`warmup_steps>0`, 则覆盖warmup_ratio.
- `--eval_steps`: 每训练多少steps进行评估, 默认为`50`.
- `--save_steps`: 每训练多少个steps进行保存, 默认为`None`, 即设置为`eval_steps`.
- `--save_only_model`: 是否只保存模型参数, 而不存储断点续训所需的中间状态, 默认为`None`, 即如果`sft_type`为'lora'并且不使用deepspeed(`deepspeed`为`None`), 设置为False, 否则设置为True(e.g. 使用了全参数微调或者使用了deepspeed).
- `--save_total_limit`: 保存的checkpoint的数量, 默认为`2`, 即保存best和last的checkpoint. 如果设置为-1, 则保存所有的checkpoint.
- `--logging_steps`: 每训练多少步打印训练信息(e.g. loss, learning_rate等), 默认为`5`.
- `--dataloader_num_workers`: 默认值为`None`, 如果是windows机器, 则设置为`0`, 否则设置为`1`.
- `--push_to_hub`: 是否将训练的checkpoint同步推送到ModelScope Hub中, 默认为`False`.
- `--hub_model_id`: 推送到的ModelScope Hub的model_id, 默认为`None`, 即设置为`f'{model_type}-{sft_type}'`. 你可以将其设置为model_id, 也可以设置为repo_name. 我们会根据hub_token推断出user_name. 推送的远程仓库如果不存在, 则会创建一个新的仓库, 如果存在, 则复用之前的仓库. 该参数只有在`push_to_hub`设置为True时才生效.
- `--hub_token`: 推送时需要的SDK token. 可以从[https://modelscope.cn/my/myaccesstoken](https://modelscope.cn/my/myaccesstoken)获取, 默认为`None`, 即从环境变量`MODELSCOPE_API_TOKEN`中获取. 该参数只有在`push_to_hub`设置为True时才生效.
- `--hub_private_repo`: 推送的ModelScope Hub中的模型仓库的权限是否设置为私有, 默认为`False`. 该参数只有在`push_to_hub`设置为True时才生效.
- `--push_hub_strategy`: 推送策略, 默认为`'push_best'`. 可选择的值包括: 'end', 'push_best', 'push_last', 'checkpoint', 'all_checkpoints'. 'push_best'表示在每次保存权重时, 将最好的模型进行推送并覆盖之前的权重, 'push_last'表示在每次保存权重时, 将最后的权重进行推送并覆盖之前的权重, 'end'表示只在训练的最后推送最好的模型. 该参数只有在`push_to_hub`设置为True时才生效.
- `--test_oom_error`: 用于检测训练是否会发生OOM, 默认为`False`. 如果设置为True, 则会将训练集按max_length倒序进行排列, 方便OOM的测试. 该参数一般用于测试, 请谨慎设置.
- `--disable_tqdm`: 是否不启用tqdm, 这在`nohup`启动脚本时很有用. 默认为`False`, 即为启动tqdm.
- `--lazy_tokenize`: 如果设置为False,  则在`trainer.train()`之前提前对所有文本进行预处理. 如果设置为True, 则延迟对文本进行编码, 减少预处理的等待并减少内存占用, 这在处理大数据集时很有用. 默认为`None`, 即我们会根据template的类型进行智能选择, LLM的模型通常设置为False, 多模态的模型通常设置为True(避免图片和音频加载导致过多的内存占用).
- `--preprocess_num_proc`: 在对数据集预处理时(对文本进行tokenize), 使用多进程. 默认为`1`. 与`lazy_tokenize`命令行参数一样, 用于解决预处理速度慢的问题. 但该策略无法减少内存占用, 所以如果当数据集巨大时, 建议使用`lazy_tokenize`. 推荐设置的值: 4, 8. 请注意: 当使用qwen-audio时, 该参数会强制设置为1, 因为qwen-audio的预处理函数中使用了torch的多进程, 会造成不兼容问题.
- `--use_flash_attn`: 是否使用flash attn, 默认为`None`. 安装flash_attn的步骤可以查看[https://github.com/Dao-AILab/flash-attention](https://github.com/Dao-AILab/flash-attention). 支持flash_attn的模型可以查看[LLM支持的模型](支持的模型和数据集.md#模型).
- `--ignore_args_error`: 是否忽略命令行传参错误抛出的Error, 默认为`False`. 如果需要拷贝代码到notebook中运行, 需要设置成True.
- `--check_model_is_latest`: 检查模型是否是最新, 默认为`True`. 如果你需要断网进行训练, 请将该参数设置为`False`.
- `--logging_dir`: 默认为`None`. 即设置为`f'{self.output_dir}/runs'`, 表示tensorboard文件存储路径.
- `--report_to`: 默认为`['tensorboard']`. 可以设置`--report_to all`来报告所有已安装的集成.
- `--acc_strategy`: 默认为`'token'`, 可选择的值包括: 'token', 'sentence'.
- `--save_on_each_node`: 该参数在多机训练时生效, 默认为`False`.
- `--save_strategy`: 保存checkpoint的策略, 默认为`'steps'`, 可选择的值包括: 'steps', 'epoch', 'no'.
- `--evaluation_strategy`: 交叉验证策略, 默认为`'steps'`, 可选择的值包括: 'steps', 'epoch', 'no'.
- `--save_safetensors`: 默认为`True`.
- `--include_num_input_tokens_seen`: 默认为`False`. 跟踪整个训练过程中观察到的输入tokens的数量.
- `--max_new_tokens`: 默认为`2048`. 该参数只有在`predict_with_generate`设置为True的时候才生效.
- `--do_sample`: 默认为`True`. 该参数只有在`predict_with_generate`设置为True的时候才生效.
- `--temperature`: 默认为`0.3`. 该参数只有在`predict_with_generate`设置为True的时候才生效.
- `--top_k`: 默认为`20`. 该参数只有在`predict_with_generate`设置为True的时候才生效.
- `--top_p`: 默认为`0.7`. 该参数只有在`predict_with_generate`设置为True的时候才生效.
- `--repetition_penalty`: 默认为`1.`. 该参数只有在`predict_with_generate`设置为True的时候才生效.
- `--num_beams`: 默认为`1`. 该参数只有在`predict_with_generate`设置为True的时候才生效.
- `--gpu_memory_fraction`: 默认为`None`. 该参数旨在指定显卡最大可用显存比例的情况下运行训练，用于极限测试.
- `--train_dataset_mix_ratio`: 默认为`0.`. 该参数定义了如何进行数据集打混训练. 指定该参数时, 会混合训练集的`train_dataset_mix_ratio`倍数的`train_dataset_mix_ds`指定的通用知识数据集. 该参数已废弃, 请使用`--dataset`进行数据集混合.
- `--train_dataset_mix_ds`: 默认为`['ms-bench']`. 用于防止知识遗忘的通用知识数据集. 该参数已废弃, 请使用`--dataset`进行数据集混合.
- `--use_loss_scale`: 默认为`False`. 生效时会将Agent的部分字段(Action/Action Input部分)的loss权重加强以强化CoT, 对普通SFT场景没有任何效果.
- `--loss_scale_config_path` 选项指定自定义的 loss_scale 配置，适用于在启用 use_loss_scale 时，例如在 Agent 训练中放大 Action 和其他关键 ReAct 字段的损失权重。
  - 在配置文件中，您可以使用字典格式来设置 loss_scale。每个键代表一个特定字段名，其关联的值设定了该字段及其后续内容的损失缩放倍数。例如，通过设定 `"Observation:": [2, 0]`，当response包含 `xxxx Observation:error` 时，`Observation:` 字段loss将增加到两倍，`error` 部分的loss则不计入。除了字面匹配，配置也支持正则表达式规则，以实现更灵活的匹配，如模式 '<.*?>':[2.0] 将针对所有尖括号括起来的部分损失增加到两倍。字段匹配与正则匹配所对应的损失缩放倍数，分别由长度为2和1的列表表示。
  - 同时支持匹配query对整段response设置loss_scale, 这在处理像[Agent-FLAN](https://arxiv.org/abs/2403.12881)论文中描述的固定多轮对话查询时极其有用，如果query中包含了预定义键的任一项，相应的响应将采用关联的 loss_scale 值。，你可以参考`swift/llm/agent/agentflan.json`
  - 默认情况下，我们为 Action:, Action Input:, Thought:, Final Answer:, 和 Observation: 等字段预设了损失缩放值。我们为[alpha-umi](https://arxiv.org/pdf/2401.07324)和[Agent-FLAN](https://arxiv.org/abs/2403.12881)也提供了默认配置，你可以设置为`alpha-umi`和`agent-flan`来使用。默认的配置文件位于`swift/llm/agent`下
  - 匹配规则的应用优先级，从高到低为：query字段 > response特定字段 > 正则表达式匹配规则。
- `--custom_register_path`: 默认为`None`. 传入`.py`文件, 用于注册模板、模型和数据集.
- `--custom_dataset_info`: 默认为`None`, 传入外置dataset_info.json的路径、json字符串或者dict. 用于拓展数据集. 格式参考: https://github.com/modelscope/swift/blob/main/swift/llm/data/dataset_info.json
- `--device_map_config_path`: 从本地文件中手动配置模型的device_map, 默认为None.
- `--device_max_memory`: 每个设备device_map的最大可用显存, `List`, 默认为`[]`, 传递的值数量必须和可见显卡数量相等. 比如`10GB 10GB`.

### Long Context

- `--rope_scaling`: 默认值`None`, 支持`linear`和`dynamic`两种scaling方式.当`max_length`超过`max_position_embeddings`时使用.
- `--rescale_image`: 是否对输入image进行rescale, 值为目标像素数, 例如480000(width * height), 所有大于此像素的图片会按照原始长宽比被缩放到这个值. 注意：并不是所有多模态模型都可以从这个参数中获益。

### FSDP参数

- `--fsdp`: 默认值`''`, fsdp类型, 详情可以查看该参数[原始文档](https://huggingface.co/docs/transformers/v4.39.3/en/main_classes/trainer#transformers.TrainingArguments.fsdp).
- `--fsdp_config`: 默认值`None`, fsdp配置文件的路径.

### Sequence Parallel参数

- `--sequence_parallel_size`: 默认值`1`, 大于1时可以拆分一个sequence到多张显卡上以节省显存, 值需要设置为能被DDP数量整除

### FourierFt 参数

FourierFt使用`target_modules`, `target_regex`, `modules_to_save`三个参数.

- `--fourier_n_frequency`: 傅里叶变换的频率数量, `int`类型, 类似于LoRA中的`r`. 默认值`2000`.
- `--fourier_scaling`: W矩阵的缩放值, `float`类型, 类似LoRA中的`lora_alpha`. 默认值`300.0`.

### BOFT参数

BOFT使用`target_modules`, `target_regex`, `modules_to_save`三个参数.

- `--boft_block_size`: BOFT块尺寸, 默认值4.
- `--boft_block_num`: BOFT块数量, 不能和`boft_block_size`同时使用.
- `--boft_dropout`: boft的dropout值, 默认0.0.

### Vera参数

Vera使用`target_modules`, `target_regex`, `modules_to_save`三个参数.

- `--vera_rank`: Vera Attention的尺寸, 默认值256.
- `--vera_projection_prng_key`: 是否存储Vera映射矩阵, 默认为True.
- `--vera_dropout`: Vera的dropout值, 默认`0.0`.
- `--vera_d_initial`: Vera的d矩阵的初始值, 默认`0.1`.

### LoRA+微调参数

- `--lora_lr_ratio`: 默认值`None`, 建议值`10~16`, 使用lora时指定该参数即可使用lora+.

### GaLore微调参数

- `--use_galore: bool` : 默认值False, 是否使用GaLore.
- `--galore_target_modules: Union[str, List[str]]` : 默认值None, 不传的情况下对attention和mlp应用GaLore.
- `--galore_rank: int` : 默认值128, GaLore的rank值.
- `--galore_update_proj_gap: int` : 默认值50, 分解矩阵的更新间隔.
- `--galore_scale: int` : 默认值1.0, 矩阵权重系数.
- `--galore_proj_type: str` : 默认值`std`, GaLore矩阵分解类型.
- `--galore_optim_per_parameter: bool` : 默认值False, 是否给每个Galore目标Parameter设定一个单独的optimizer.
- `--galore_with_embedding: bool` : 默认值False, 是否对embedding应用GaLore.
- `--galore_quantization` 是否使用q-galore. 默认值`False`.
- `--galore_proj_quant`: 是否对SVD分解矩阵做量化, 默认`False`.
- `--galore_proj_bits`: SVD量化bit数.
- `--galore_proj_group_size`: SVD量化分组数.
- `--galore_cos_threshold`: 投影矩阵更新的cos相似度阈值. 默认值0.4.
- `--galore_gamma_proj`: 在投影矩阵逐渐相似后会拉长更新间隔, 本参数为每次拉长间隔的系数, 默认值2.
- `--galore_queue_size`: 计算投影矩阵相似度的队列长度, 默认值5.

### LISA微调参数

注意：LISA仅支持全参数，即`--sft_type full`.

- `--lisa_activated_layers`: 默认值`0`, 代表不使用LISA，改为非0代表需要激活的layers个数，建议设置为2或8.
- `--lisa_step_interval`: 默认值`20`, 多少iter切换可反向传播的layers.

### UNSLOTH微调参数

unsloth无新增参数，对已有参数进行调节即可支持：

```
--tuner_backend unsloth
--sft_type full/lora
--quantization_type 4
```

### LLAMAPRO微调参数

- `--llamapro_num_new_blocks`: 默认值`4`, 插入的新layers总数.
- `--llamapro_num_groups`: 默认值`None`, 分为多少组插入new_blocks, 如果为`None`则等于`llamapro_num_new_blocks`, 即每个新的layer单独插入原模型.

### AdaLoRA微调参数

以下参数`sft_type`设置为`adalora`时生效. adalora的`target_modules`等参数继承于lora的对应参数, 但`lora_dtype`参数不生效.

- `--adalora_target_r`: 默认值`8`, adalora的平均rank.
- `--adalora_init_r`: 默认值`12`, adalora的初始rank.
- `--adalora_tinit`: 默认值`0`, adalora的初始warmup.
- `--adalora_tfinal`: 默认值`0`, adalora的final warmup.
- `--adalora_deltaT`: 默认值`1`, adalora的step间隔.
- `--adalora_beta1`: 默认值`0.85`, adalora的EMA参数.
- `--adalora_beta2`: 默认值`0.85`, adalora的EMA参数.
- `--adalora_orth_reg_weight`: 默认值`0.5`, adalora的正则化参数.

### IA3微调参数

IA3使用`target_modules`, `target_regex`, `modules_to_save`三个参数.

以下参数`sft_type`设置为`ia3`时生效.

- `--ia3_feedforward_modules`: 指定IA3的MLP的Linear名称, 该名称必须在`ia3_target_modules`中.

## PT 参数

PT参数继承了sft参数，并修改了部分默认值.
- `--sft_type`: 默认值为`'full'`.
- `--target_modules`: 默认值为`'ALL'`.
- `--lazy_tokenize`: 默认值为`True`.
- `--eval_steps`: 默认值为`500`.

## RLHF 参数

RLHF参数继承了sft参数, 除此之外增加了以下参数:
- `--rlhf_type`: 选择对齐算法，可选项为'dpo', 'orpo', 'simpo', 'kto', 'cpo', 训练脚本请查看[文档](./人类偏好对齐训练文档.md)
- `--ref_model_type`: 选择参考模型, 同model_type参数, 默认与训练模型一致。其中`cpo`和`simpo`算法无需选择。
- `--ref_model_id_or_path`: 参考模型的本地cache路径, 默认为`None`.
- `--max_prompt_length`: 最大的提示长度, 该参数会传入相应的Trainer中, 使prompt长度不超过该值的设置, 默认值`1024`.
- `--beta`: KL正则项系数, `simpo`算法默认为2.0, 其他算法默认为0.1, 具体参考[文档](./人类偏好对齐训练文档.md)
- `--label_smoothing`: 是否使用DPO smoothing, 默认值为0，一般设置在0~0.5之间.
- `--loss_type`: loss类型, 默认值'sigmoid'.
- `--sft_beta`: 是否在DPO中加入sft loss, 默认为0.1, 支持 $[0, 1)$ 区间，最后的loss为`(1-sft_beta)*KL_loss + sft_beta * sft_loss`.
- `--simpo_gamma`: SimPO算法中的reward margin项，论文中建议设置为0.5-1.5, 默认为1.0
- `--cpo_alpha`: CPO loss 中 nll loss的系数, 默认为1.0, 在SimPO中使用混合nll loss以提高训练稳定性
- `--desirable_weight`: KTO算法中对desirable response的loss权重 $\lambda_D$ ，默认为1.0
- `--undesirable_weight`: KTO论文中对undesirable response的loss权重 $\lambda_U$ , 默认为1.0. 分别用$n_d$ 和$n_u$ 表示数据集中desirable examples和undesirable examples的数量，论文中推荐控制 $\frac{\lambda_D n_D}{\lambda_Un_U} \in [1,\frac{4}{3}]$

## infer merge-lora 参数

- `--model_type`: 默认值为`None`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--model_id_or_path`: 默认值为`None`, 具体的参数介绍可以在`sft命令行参数`中查看. 推荐使用model_type的方式指定.
- `--model_revision`: 默认值为`None`. 具体的参数介绍可以在`sft命令行参数`中查看. 如果`model_id_or_path`为None或者是本地的模型目录, 则该参数失效.
- `--sft_type`: 默认值为`'lora'`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--template_type`: 默认值为`'AUTO'`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--infer_backend`: 你可以选择'AUTO', 'vllm', 'pt'. 默认使用'AUTO', 进行智能选择, 即如果没有传入`ckpt_dir`或使用全参数微调, 并且安装了vllm且模型支持vllm则使用vllm引擎, 否则使用原生torch进行推理. vllm环境准备可以参考[VLLM推理加速与部署](VLLM推理加速与部署.md#环境准备), vllm支持的模型可以查看[支持的模型](支持的模型和数据集.md#模型).
- `--ckpt_dir`: 必填项, 值为SFT阶段保存的checkpoint路径, e.g. `'/path/to/your/vx-xxx/checkpoint-xxx'`.
- `--load_args_from_ckpt_dir`: 是否从`ckpt_dir`的`sft_args.json`文件中读取模型配置信息. 默认是`True`.
- `--load_dataset_config`: 该参数只有在`--load_args_from_ckpt_dir true`时才生效. 即是否从`ckpt_dir`的`sft_args.json`文件中读取数据集相关的配置信息. 默认为`False`.
- `--eval_human`: 使用数据集中的验证集部分进行评估还是使用人工的方式评估. 默认值为`None`, 进行智能选择,  如果没有任何数据集(含自定义数据集)传入, 则会使用人工评估的方式. 如果有数据集传入, 则会使用数据集方式评估.
- `--device_map_config_path`: 从本地文件中手动配置模型的device_map, 默认为None.
- `--device_max_memory`: 每个设备device_map的最大可用显存, `List`, 默认为`[]`, 传递的值数量必须和可见显卡数量相等. 比如`10GB 10GB`.
- `--seed`: 默认值为`42`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--dtype`: 默认值为`'AUTO`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--dataset`: 默认值为`[]`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--val_dataset`: 默认为`[]`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--dataset_seed`: 默认值为`None`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--dataset_test_ratio`: 默认值为`0.01`. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--show_dataset_sample`: 表示想要评估和展示的验证集的数量, 默认值为`10`.
- `--system`: 默认值为`None`. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--tools_prompt`: 默认值为`react_en`. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--max_length`: 默认值为`-1`. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--truncation_strategy`: 默认是`'delete'`. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--check_dataset_strategy`: 默认值为`'none'`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--custom_train_dataset_path`: 默认值为`[]`. 该参数已废弃, 请使用`--dataset {dataset_path}`.
- `--custom_val_dataset_path`: 默认值为`[]`. 该参数已废弃. 请使用`--val_dataset {dataset_path}`.
- `--quantization_bit`: 默认值为0. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--quant_method`: 量化方法, 默认为`None`. 你可以选择为'bnb', 'hqq', 'eetq'.
- `--hqq_axis`: hqq量化参数，表示执行分组的所沿的轴，默认为`0`, 可选值包括`0`,`1`
- `--hqq_dynamic_config_path`: hqq本地配置路径，支持对模型不同层配置不同的量化配置，[参考](https://github.com/mobiusml/hqq?tab=readme-ov-file#custom-quantization-configurations-%EF%B8%8F)
- `--bnb_4bit_comp_dtype`: 默认值为`'AUTO'`.  具体的参数介绍可以在`sft命令行参数`中查看. 若`quantization_bit`设置为0, 则该参数失效.
- `--bnb_4bit_quant_type`: 默认值为`'nf4'`.  具体的参数介绍可以在`sft命令行参数`中查看. 若`quantization_bit`设置为0, 则该参数失效.
- `--bnb_4bit_use_double_quant`: 默认值为`True`.  具体的参数介绍可以在`sft命令行参数`中查看. 若`quantization_bit`设置为0, 则该参数失效.
- `--bnb_4bit_quant_storage`: 默认值为`True`. 具体的参数介绍可以在`sft命令行参数`中查看. 若`quantization_bit`设置为0, 则该参数失效.
- `--max_new_tokens`: 生成新token的最大数量, 默认值为`2048`.
- `--do_sample`: 是使用贪婪生成的方式还是采样生成的方式, 默认值为`True`.
- `--temperature`: 默认值为`0.3`. 该参数只有在`do_sample`设置为True时才生效. 该参数会在部署参数中作为默认值使用.
- `--top_k`: 默认值为`20`. 该参数只有在`do_sample`设置为True时才生效. 该参数会在部署参数中作为默认值使用.
- `--top_p`: 默认值为`0.7`. 该参数只有在`do_sample`设置为True时才生效. 该参数会在部署参数中作为默认值使用.
- `--repetition_penalty`: 默认值为`1.`. 该参数会在部署参数中作为默认值使用.
- `--num_beams`: 默认为`1`.
- `--use_flash_attn`: 默认值为`None`, 即为'auto'. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--ignore_args_error`: 默认值为`False`, 具体的参数介绍可以在`sft命令行参数`中查看.
- `--stream`: 是否使用流式输出, 默认为`True`. 该参数只有在使用数据集评估并且verbose为True时才生效.
- `--merge_lora`: 是否将lora权重merge到基模型中, 并保存完整的权重, 默认为`False`. 权重会保存在`ckpt_dir`的同级目录中, e.g. `'/path/to/your/vx-xxx/checkpoint-xxx-merged'`目录下.
- `--merge_device_map`: merge-lora时使用的device_map, 默认为`None`, 为减少显存占用, 在仅有merge-lora过程时使用`auto`，其他情况默认使用`cpu`.
- `--save_safetensors`: 保存成`safetensors`文件还是`bin`文件. 默认为`True`.
- `--overwrite_generation_config`: 是否将评估所使用的generation_config保存成`generation_config.json`文件, 默认为`None`. 如果指定了`ckpt_dir`, 则设置为`True`, 否则设置为`False`. 训练时保存的generation_config文件将被覆盖.
- `--verbose`: 如果设置为False, 则使用tqdm样式推理. 如果设置为True, 则输出推理的query, response, label. 默认为`None`, 进行自动选择, 即`len(val_dataset) >= 100`时, 设置为False, 否则设置为True. 该参数只有在使用数据集评估时生效.
- `--lora_modules`: 默认为`[]`, 输入的格式为`'{lora_name}={lora_path}'`, e.g. `--lora_modules lora_name1=lora_path1 lora_name2=lora_path2`. `ckpt_dir`会以`f'default-lora={args.ckpt_dir}'`的形式加入args.lora_modules.
- `--custom_register_path`: 默认为`None`. 传入`.py`文件, 用于注册模板、模型和数据集.
- `--custom_dataset_info`: 默认为`None`, 传入外置dataset_info.json的路径、json字符串或者dict. 用于拓展数据集.
- `--rope_scaling`: 默认值`None`, 支持`linear`和`dynamic`两种scaling方式, 当`max_length`超过`max_position_embeddings`时使用. 需要同时指定`--max_length`参数.

### vLLM 参数

- `--gpu_memory_utilization`: 初始化vllm引擎`EngineArgs`的参数, 默认为`0.9`. 该参数只有在使用vllm时才生效. VLLM推理加速和部署可以查看[VLLM推理加速与部署](VLLM推理加速与部署.md).
- `--tensor_parallel_size`: 初始化vllm引擎`EngineArgs`的参数, 默认为`1`. 该参数只有在使用vllm时才生效.
- `--max_num_seqs`: 初始化vllm引擎`EngineArgs`的参数, 默认为`256`. 该参数只有在使用vllm时才生效.
- `--max_model_len`: 覆盖模型的max_model_len, 默认为`None`. 该参数只有在使用vllm时才生效.
- `--disable_custom_all_reduce`: 是否禁用自定义的all-reduce kernel, 而回退到NCCL. 默认为`True`, 这与vLLM的默认值不同.
- `--enforce_eager`: vllm使用pytorch eager模式还是建立cuda graph. 默认为`False`. 设置为True可以节约显存, 但会影响效率.
- `--vllm_enable_lora`: 默认为`False`. 是否开启vllm对lora的支持. 具体可以查看[VLLM & LoRA](VLLM推理加速与部署.md#vllm--lora).
- `--vllm_max_lora_rank`: 默认为`16`. vllm对于lora支持的参数.
- `--lora_modules`: 已介绍.

### lmdeploy 参数
- `--tp`: tensor并行, 用于初始化lmdeploy引擎的参数, 默认值为`1`.
- `--cache_max_entry_count`: 初始化lmdeploy引擎的参数, 默认值为`0.8`.
- `--quant_policy`: Key-Value Cache量化, 初始化lmdeploy引擎的参数, 默认值为`0`, 你可以设置为4, 8.
- `--vision_batch_size`: 初始化lmdeploy引擎的参数, 默认值为`1`. 该参数只有在使用多模态模型时生效.


## export 参数

export参数继承了infer参数, 除此之外增加了以下参数:

- `--to_peft_format`: 默认为`False`. 将lora的swift format（`--tuner_backend swift`）转成peft format.
- `--merge_lora`: 默认为`False`. 该参数已在InferArguments中定义, 不属于新增参数. 是否将lora权重merge到基模型中, 并保存完整的权重. 权重会保存在`ckpt_dir`的同级目录中, e.g. `'/path/to/your/vx-xxx/checkpoint-xxx-merged'`目录下.
- `--quant_bits`: 量化的bits数. 默认为`0`, 即不进行量化. 如果你设置了`--quant_method awq`, 你可以设置为`4`进行4bits量化. 如果你设置了`--quant_method gptq`, 你可以设置为`2`,`3`,`4`,`8`进行对应bits的量化. 如果对原始模型进行量化, 权重会保存在`f'{args.model_type}-{args.quant_method}-int{args.quant_bits}'`目录中. 如果对微调后模型进行量化, 权重会保存在`ckpt_dir`的同级目录中, e.g. `f'/path/to/your/vx-xxx/checkpoint-xxx-{args.quant_method}-int{args.quant_bits}'`目录下.
- `--quant_method`: 量化方法, 默认为`'awq'`. 你可以选择为'awq', 'gptq', 'bnb'.
- `--dataset`: 该参数已在InferArguments中定义, 在export时含义为量化数据集. 默认为`[]`. 更多细节: 包括如何自定义量化数据集, 可以参考[LLM量化与导出文档](LLM量化与导出文档.md).
- `--quant_n_samples`: 量化参数, 默认为`256`. 当设置为`--quant_method awq`时, 如果出现量化的时候OOM, 可以适度降低`--quant_n_samples`和`--quant_seqlen`. `--quant_method gptq`通常不会出现量化OOM.
- `--quant_seqlen`: 量化参数, 默认为`2048`.
- `--quant_batch_size`: 量化数据集的batch_size，默认为`1`.
- `--quant_device_map`: 默认为`'cpu'`, 节约显存. 你可以指定为'cuda:0', 'auto', 'cpu'等, 表示量化时模型导入的设备. 该参数与实际执行量化的设备无关, 例如awq和gptq会在cuda:0中进行量化.
- `--quant_output_dir`: 默认为`None`, 默认的quant_output_dir会被打印在命令行中.
- `--push_to_hub`: 默认为`False`. 是否将最后的`ckpt_dir`push到ModelScope Hub中. 如果你指定了`merge_lora`, 则将推送全量参数; 如果你还指定了`quant_bits`, 则将推送量化后的模型.
- `--hub_model_id`: 默认为`None`. 推送到的ModelScope Hub的model_id. 如果`push_to_hub`设置为True, 该参数必须被设置.
- `--hub_token`: 默认为`None`. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--hub_private_repo`: 默认为`False`. 具体的参数介绍可以在`sft命令行参数`中查看.
- `--commit_message`: 默认是`'update files'`.
- `--to_ollama`: 转为ollama导出.
- `--ollama_output_dir`: ollama输出目录. 默认存储在当前目录下的`模型类型-ollama`文件夹内.

## eval参数

eval参数继承了infer参数，除此之外增加了以下参数：（注意: infer中的generation_config参数将失效, 由[evalscope](https://github.com/modelscope/eval-scope)控制.）

- `--eval_dataset`: 评测的官方数据集, 默认值为空, 代表全量评测, 注意指定了custom_eval_config时本参数不生效. [查看所有支持的评测集](./LLM评测文档.md#能力介绍).
- `--eval_few_shot`: 每个评测集的子数据集的few-shot个数, 默认为`None`, 即使用数据集的默认配置. **本参数暂时废弃**
- `--eval_limit`: 每个评测集的子数据集的采样数量, 默认为`None`代表全量评测. 可以传入整数, 表示每个数据集的评测数量, 也可以传入string, 如`[10:20]`, 代表切片.
- `--name`: 用于区分相同配置评估的结果存储路径. 如: `{eval_output_dir}/{name}`, 默认在：`eval_outputs/defaults`, 其内部存在以时间命名的文件夹来承载每次评测结果.
- `--eval_url`: OpenAI标准的模型调用接口, 例如`http://127.0.0.1:8000/v1`. 如果使用部署的方式评估, 则需要进行设置, 通常不需要设置. 默认为`None`.
  ```shell
  swift eval --eval_url http://127.0.0.1:8000/v1 --eval_is_chat_model true --model_type gpt4 --eval_token xxx
  ```
- `--eval_token`: OpenAI标准的模型调用接口的token, 默认为`'EMPTY'`, 代表没有token.
- `--eval_is_chat_model`: 如果`eval_url`不为空, 则需要传入本值判断是否为`chat`模型, False代表为`base`模型. 默认为`None`.
- `--custom_eval_config`: 使用自定义数据集进行评测, 需要是一个本地存在的文件路径, 文件格式详见[自定义评测集](./LLM评测文档.md#自定义评测集). 默认为`None`.
- `--eval_use_cache`: 是否使用已经生成的评测缓存, 使做过的评测不会重新运行而只是重新生成评测结果. 默认`False`.
- `--eval_output_dir`: 评测结果输出路径, 默认是当前文件夹下的`eval_outputs`路径.
- `--eval_batch_size`: 评测的输入batch_size, 默认是8
- `--deploy_timeout`: 评测之前会启动模型部署, 该参数设置部署的等待超时时长, 默认值为60, 代表一分钟.


## app-ui 参数

app-ui参数继承了infer参数, 除此之外增加了以下参数:

- `--host`: 默认为`'127.0.0.1'`. 传递给gradio的`demo.queue().launch(...)`函数.
- `--port`: 默认为`7860`. 传递给gradio的`demo.queue().launch(...)`函数.
- `--share`: 默认为`False`. 传递给gradio的`demo.queue().launch(...)`函数.

## deploy 参数

deploy参数继承了infer参数, 除此之外增加了以下参数:

- `--host`: 默认为`'127.0.0.1`. 要使其在非本机上可访问, 可设置为'0.0.0.0'.
- `--port`: 默认为`8000`.
- `--api_key`: 默认为`None`, 即不对请求进行api_key验证.
- `--ssl_keyfile`: 默认为`None`.
- `--ssl_certfile`: 默认为`None`.
- `--verbose`: 是否对请求内容进行打印, 默认为`True`.
- `--log_interval`: 对统计信息进行打印的间隔, 单位为秒. 默认为`10`. 如果设置为`0`, 表示不打印统计信息.

## web-ui 参数

- `--host`: 默认为`'127.0.0.1'`. 要使其在非本机上可访问, 可设置为'0.0.0.0'.
- `--port`: 默认为`None`.
- `--lang`: 默认为`'zh'`.
- `--share`: 默认为`False`.
