import os
from PIL import Image

# 配置路径
ref_dir = "./datasets/Set5/image_SRF_2/HR/"  # 原参考图目录（512x512）
resized_ref_dir = "./datasets/Set5/image_SRF_2/HR_1024/"  # 调整后参考图目录（1024x1024）

# 创建输出目录
os.makedirs(resized_ref_dir, exist_ok=True)

# 批量调整尺寸（bicubic 插值）
for img_name in os.listdir(ref_dir):
    if img_name.endswith((".png", ".jpg", ".jpeg")):
        img_path = os.path.join(ref_dir, img_name)
        save_path = os.path.join(resized_ref_dir, img_name)
        
        # 打开图片并放大到 1024x1024
        with Image.open(img_path) as img:
            resized_img = img.resize((1024, 1024), Image.BICUBIC)
            resized_img.save(save_path, quality=100)
        
        print(f"已调整：{img_name} → 1024x1024")

print(f"\n✅ 所有参考图已保存到：{resized_ref_dir}")
