需要用到xformers，所以使用的镜像是 image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10

dtk25.04.1和dtk25.04.2的镜像中没有适配安装xformers

```
# 拉取镜像
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10
# 创建容器
docker run -it --network=host --name=dtk24043_torch23 -v /opt/hyhal:/opt/hyhal:ro -v /usr/local/hyhal:/usr/local/hyhal:ro -v /public:/public:ro --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=128G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10
```

```
git clone https://github.com/ArcticHare105/S3Diff.git
cd S3Diff/
pip install -r requirements.tx    # 安装环境中缺少的依赖，已有的进行注释，open-clip-torch、peft、diffusers、huggingface_hub要安装指定版本！！！
# 安装diffusers
pip install diffusers==0.25.1
```

## 推理

#### Step1: 下载推理数据

推理数据没有开源，需要自行准备数据集

需将下载的数据集按以下结构整理（以 Set5 为例）

```plaintext
dataset/
├── Set5/
│   ├── LR (低分辨率图像，作为输入)
│   └── HR (高分辨率图像，作为GT，用于评估)
```

#### Step2: 下载预训练模型

We enable automatic model download in our code, if you need to conduct offline inference, download the pretrained model [SD-Turbo](https://huggingface.co/stabilityai/sd-turbo) and S3Diff [[HuggingFace](https://huggingface.co/zhangap/S3Diff) | [GoogleDrive](https://drive.google.com/drive/folders/1cWYQYRFpadC4K2GuH8peg_hWEoFddZtj?usp=sharing)]

You can put the weight into `pretrained_weight/`

#### Step3: 推理

Please add the paths to evaluate datasets in `configs/sr_test.yaml` and the path of GT folder in `run_inference.sh` Then run:

```
sh run_inference.sh
```

脚本中代码如下：

```
accelerate launch --num_processes=1 --gpu_ids="0," --main_process_port 29300 src/inference_s3diff.py \
    --de_net_path="./pretrained_weight/zhangap/S3Diff/de_net.pth" \
    --output_dir="./output" \
    --ref_path="./datasets/Set5/image_SRF_2/HR_1024/" \
    --align_method="wavelet"
```

src/inference_s3diff.py脚本中预训练模型改成自己的路径，如下：

```
# pretrained_path = hf_hub_download(repo_id="zhangap/S3Diff", filename="s3diff.pkl")   # 源代码
pretrained_path = "./pretrained_weight/zhangap/S3Diff/s3diff.pkl"                      ###


# from huggingface_hub import snapshot_download
# sd_path = snapshot_download(repo_id="stabilityai/sd-turbo")
# 直接使用本地已下载的 sd-turbo路径
sd_path = "./pretrained_weight/stabilityai/sd-turbo/"
```