# S3Diff

## 论文

Degradation-Guided One-Step Image Super-Resolution with Diffusion Priors

https://arxiv.org/abs/2409.17058v1

## 模型结构

S3Diff 是一种基于扩散先验的退化引导一步图像超分辨率方法。该方法通过利用预先训练的文本到图像扩散模型作为先验，解决传统图像超分辨率方法效率低下和忽视退化模型关键信息的问题。S3Diff 采用退化引导的低秩适应（LoRA）模块，根据低分辨率图像预先估计的退化信息来纠正模型参数，不仅提升了数据依赖或退化依赖的超分辨率模型的能力，还尽可能保留了预训练扩散模型的生成先验。

![image](https://developer.sourcefind.cn/codes/modelzoo/S3Diff/-/raw/master/assets/pic/main_framework.jpg?inline=false)

## 环境配置

### Docker（方法一）

```
在光源可拉取docker镜像：
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10
创建并启动容器：
docker run -it --network=host --name=dtk24043_torch23 -v /opt/hyhal:/opt/hyhal:ro -v /usr/local/hyhal:/usr/local/hyhal:ro -v /public:/public:ro --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=128G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10
docker exec -it dtk24043_torch23 /bin/bash
安装依赖包：
cd S3Diff/
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
# 安装环境中缺少的依赖，已有的进行注释，open-clip-torch、peft、diffusers、huggingface_hub要安装指定版本！！！
```
### Dockerfile（方法二）

```
docker build --no-cache -t S3Diff:latest .
docker run -dit --network=host --name=STAR --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 -v /opt/hyhal/:/opt/hyhal/:ro -v /usr/local/hyhal:/usr/local/hyhal:ro S3Diff:latest
docker exec -it S3Diff /bin/bash
安装依赖包：
cd S3Diff/
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
# 安装环境中缺少的依赖，已有的进行注释，open-clip-torch、diffusers要安装指定版本！！！
sudo apt-get update && sudo apt-get install ffmpeg libsm6 libxext6  -y
```

### Anaconda（方法三）

```
1.创建conda虚拟环境：
conda create -n S3Diff python=3.10
2.关于本项目DCU显卡所需的工具包、深度学习库等均可从光合开发者社区下载安装：https://developer.hpccube.com/tool/
DTK驱动：dtk24.04.3
python：python3.10
torch:2.3.0
Tips：以上DTK、python、torch等DCU相关工具包，版本需要严格一一对应，torch2.1或2.3或2.4都可以
3.其它非特殊库参照requirements.txt安装
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

## 测试数据集

推理数据没有指定开源，需要自行准备数据集，需将下载的数据集按以下结构整理（以 Set5 为例）

```
dataset/
├── Set5/
│   ├── LR (低分辨率图像，作为输入)
│   └── HR (高分辨率图像，作为GT，用于评估)
```

本项目在dataset目录下提供了可供测试的示例数据集。

## 预训练模型

我们在代码中支持自动模型下载，如果您需要进行离线推理，请下载预训练模型[SD-Turbo](https://huggingface.co/stabilityai/sd-turbo)和S3Diff [[HuggingFace](https://huggingface.co/zhangap/S3Diff) | [GoogleDrive](https://drive.google.com/drive/folders/1cWYQYRFpadC4K2GuH8peg_hWEoFddZtj?usp=sharing)]

本项目提供了Huggingface快速下载脚本，可以运行以下命令将权重文件下载到本地`./pretrained_weight/`目录下

```
python downmodel.py
```

## 推理

#### 单机单卡推理

请在 configs/sr_test.yaml 中添加评估数据集的路径，并在 run_inference.sh 中添加 GT 文件夹的路径，然后运行：

```
sh run_inference.sh
```

src/inference_s3diff.py脚本中预训练模型改成自己本地的路径，如下：

```
# pretrained_path = hf_hub_download(repo_id="zhangap/S3Diff", filename="s3diff.pkl")   # 源代码
pretrained_path = "./pretrained_weight/zhangap/S3Diff/s3diff.pkl"  

# from huggingface_hub import snapshot_download
# sd_path = snapshot_download(repo_id="stabilityai/sd-turbo")
# 直接使用本地已下载的 sd-turbo路径
sd_path = "./pretrained_weight/stabilityai/sd-turbo/"
```

## result

无

## 精度

无

### 应用场景

### 算法类别

图像超分辨率

### 热点应用行业

医疗,教育,科研,金融

## 源码仓库及问题反馈

- https://developer.sourcefind.cn/codes/modelzoo/S3Diff
## 参考资料
- https://github.com/ArcticHare105/S3Diff

  
