# OmniParser

## 论文

`OmniParser for Pure Vision Based GUI Agent`

* https://arxiv.org/pdf/2408.00203

## 模型结构

该方法使用三个模块，分别是

1、可交互图标检测模型（YOLOv8）：这个模型用于在屏幕上解析可交互区域，并标注出可能的交互图标。

2、图标描述模型（Florence-2）：这个模型用于提取检测到的图标的功能语义，为每个图标提供描述性的标签。

3、OCR模块：这个模块用于识别屏幕上的文本内容，包括按钮标签、提示信息等，这些信息对于理解UI的上下文至关重要。

![alt text](readme_imgs/arch.png)

## 算法原理

该算法集成了一个微调的可交互图标检测模型的输出、一个微调的图标描述模型和一个OCR模块的输出。这种组合产生了UI的结构化、类似DOM的表示，以及带有潜在可交互元素边界框的截图。

![alt text](readme_imgs/alg.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10

    docker run --shm-size 50g --network=host --name=dpskr1 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install https://download.sourcefind.cn:65024/directlink/4/paddle/DAS1.3/paddlepaddle-2.6.1+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl

    pip install -r requirements.txt

### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 50g --network=host --name=dpskr1 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install https://download.sourcefind.cn:65024/directlink/4/paddle/DAS1.3/paddlepaddle-2.6.1+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl
    
    pip install -r requirements.txt

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
torch: 2.3.0
torchvision: 0.18.1
padlepadle: 2.6.1
```

2、其他非特殊库直接按照requirements.txt安装

```
pip install -r requirements.txt
```

## 数据集

本项目提供了用于测试的数据集：./imgs/

## 训练

无

## 推理

### 命令行

```bash
python demo.py --img_path <图像路径>
```

### webui

```bash
python gradio_demo.py
```

## result

![alt text](readme_imgs/demo.png)

### 精度

无

## 应用场景

### 算法类别

`目标检测`

### 热点应用行业

`电商,教育,广媒`

## 预训练权重

权重存放于目录：./weights/OmniParser-v2

OmniParser-v2.0：[huggingface](https://hf-mirror.com/microsoft/OmniParser-v2.0)

## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/Omniparser_pytorch

## 参考资料

* https://github.com/microsoft/OmniParser/
