# MiniCPM4
速度狂飙，快至220倍！MiniCPM4.0-8B是首个原生稀疏模型，5%的极高稀疏度加持系统级创新技术的大爆发，宣告了端侧长文本时代到来！
## 论文
`MiniCPM4: Ultra-Efficient LLMs on End Devices`
- https://arxiv.org/pdf/2506.07900

## 模型结构
MiniCPM4核心架构基于Transformer Decoder-only，引入InfLLM 2.0混合稀疏注意力结构，采用「高效双频换挡」机制，能够根据任务特征自动切换注意力模式：在处理高难度的长文本、深度思考任务时，启用稀疏注意力以降低计算复杂度，在短文本场景下切换至稠密注意力以确保精度，实现了长、短文本切换的高效响应。
<div align=center>
    <img src="./doc/structure.png"/>
</div>

## 算法原理
MiniCPM 4.0模型采用的InfLLMv2稀疏注意力架构改变了传统Transformer模型的相关性计算方式：对分块分区域高效「抽查」，即对文本进行分块分区域处理后，通过智能化选择机制，只需对最有相关性的重点区域进行注意力计算“抽查”，摆脱了逐字重复计算的低效，注意力层仅需1/10的计算量即可完成长文本计算。
<div align=center>
    <img src="./doc/Sparse_Attention.png"/>
</div>

## 环境配置
```
mv MiniCPM4_pytorch MiniCPM4
```

### 硬件需求
DCU型号：K100AI，节点数量：1 台，卡数：4 张。

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.10
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：e50d644287fd
docker run -it --shm-size=64G -v $PWD/MiniCPM4:/home/MiniCPM4 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name minicpm4 <your IMAGE ID> bash
cd /home/MiniCPM4
pip install -r requirements.txt # requirements.txt
```
### Dockerfile（方法二）
```
cd /home/MiniCPM4/docker
docker build --no-cache -t minicpm4:latest .
docker run --shm-size=64G --name minicpm4 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../MiniCPM4:/home/MiniCPM4 -it minicpm4 bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.sourcefind.cn/tool/
```
DTK驱动:25.04.1
python:python3.10
torch:2.4.1
torchvision:0.19.1
triton:3.0.0
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.4.0
transformers:4.53.2
```

不同深度学习库可支持的DCU型号可在此处查询：[DAS资源下载](https://das.sourcefind.cn:55011/portal/#/home)

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/MiniCPM4
pip install -r requirements.txt # requirements.txt
```

报错解决：
```
1、TypeError: Phi3LongRoPEScaledRotaryEmbedding._compute_cos_sin_cache() missing 3 required positional arguments: 'max_position_embeddings', 'rescale_factors', and 'mscale'

File "/usr/local/lib/python3.10/dist-packages/vllm/model_executor/models/minicpm.py", line 245
下面这一行代码是不必要的，因为RotaryEmbedding构造函数已经处理了适当的缓存初始化，注释掉：
# self.rotary_emb.cos_sin_cache = self.rotary_emb._compute_cos_sin_cache(
# )

2、ValueError: You must use the new past_key_values format, such as the Cache class, instead of the old tuple format.
openbmb/MiniCPM4-8B/modeling_minicpm.py", line 2052
将下面代码：
if use_legacy_cache:
    raise ValueError(
        'You must use the new past_key_values format, such as the Cache class, instead of the old tuple format.'
    )
    past_key_values = DynamicCache.from_legacy_cache(past_key_values)
替换成：
past_key_values = DynamicCache.from_legacy_cache(past_key_values)
```

## 数据集
`项目中官方提供了用于试验的示例数据集`

```
/home/MiniCPM4/finetune/data/
    ├── AdvertiseGenChatML
    |   ├── train.json
    |   └── dev.json
    └── ocnli_public_chatml
        ├── train.json
        └── dev.json
```
更多资料可参考源项目的[`README_origin`](./README_origin.md)

## 训练

### 单机多卡
预训练权重目录结构：
```
/home/MiniCPM4/
    └── openbmb/MiniCPM4-8B
``` 

```
cd /home/MiniCPM4/finetune
bash lora_finetune_minicpm4.sh # 此处以MiniCPM4-8B为例，其它参数量的模型以此类推。
```

## 推理

### 单机单卡

```
cd /home/MiniCPM4

# 方法一：transformers推理
python infer_transformers.py

# 方法二：vllm推理
python infer_vllm.py # 官方版vLLM目前不支持InfLLM-v2。
# 目前已开放dense推理，投机采样、量化、量化加投机敬请期待后续vllm的适配优化。
```
更多资料可参考源项目的[`README_origin`](./README_origin.md)

## result
此处以vllm版的推理结果示例：

`输入: `
```
推荐5个北京的景点。
```

`输出:`
```
北京，这座历史悠久、文化底蕴深厚的城市，拥有众多令人向往的景点。以下是五个不容错过的北京景点推荐：

1. **故宫博物院**：作为明清两代皇家宫殿，故宫不仅是世界上最大的木质结构建筑群，也是中国乃至世界上最大的古代宫廷博物馆。这里收藏着大量的珍贵文物，如书画、瓷器、玉器等，能够让人近距离感受到中国传统文化的魅力。

2. **长城**：作为中华民族的象征，长城是中国古代军事防御工程的杰出代表。其中，八达岭长城是最为著名的一段，其地势险峻，长城蜿蜒曲折，是游客体验长城雄伟壮观的最佳地点。

3. **天安门广场**：作为世界上最大的城市中心广场，天安门广场不仅是国家的重要政治活动场所，也是游客们欣赏宏伟建筑的好去处。广场上的天安门城楼、人民英雄纪念碑、毛主席纪念堂等，都是历史的见证。

4. **颐和园**：颐和园是中国保存最完整的皇家园林，以其精美的园林艺术和丰富的文化内涵而著称。园内的昆明湖、万寿山、长廊等景点，让人仿佛置身于一幅生动的中国山水画中。

5. **圆明园**：虽然历经劫难，但圆明园的残垣断壁依然透露出清朝皇家园林的辉煌。园内的荷花池、西洋楼遗址等，让人在感叹历史的同时，也能感受到中国园林艺术的精妙。

以上五个景点，不仅能够让人领略到北京深厚的历史文化底蕴，也是来京旅游者必访之地。
```

### 精度
DCU与GPU精度一致，推理框架：vllm，训练中所用数据为少量demo数据，仅供模型训练方法测试，故无法作为训练精度参考。

## 应用场景
### 算法类别
`对话问答`
### 热点应用行业
`制造,广媒,金融,能源,医疗,家居,教育`
## 预训练权重
魔搭社区下载地址为：[OpenBMB/MiniCPM4-8B](https://www.modelscope.cn/models/OpenBMB/MiniCPM4-8B)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/MiniCPM4_pytorch.git
## 参考资料
- https://github.com/OpenBMB/MiniCPM.git

