# MegaTTS 3
骨干网络仅含0.45B参数，支持口音强度控制，适于实时语音交互，能满足不同场景下对语音口音克隆的多样化需求。

## 论文
`MegaTTS 3: Sparse Alignment Enhanced Latent Diffusion Transformer for Zero-Shot Speech Synthesis`
- https://arxiv.org/pdf/2502.18924

## 模型结构
MegaTTS3 采用WaveVAE+Latent Diffusion Transformer双模块协同合作，创造出超高质量的语音合成效果。
<div align=center>
    <img src="./doc/MegaTTS3.png"/>
</div>

## 算法原理
1、WaveVAE：负责将原始语音信号压缩成潜在向量，并通过解码器进行还原，确保语音合成的高保真度。

2、DiT：通过自注意力机制对潜在向量序列进行建模，将文本和语音信号之间进行细致的对齐。

3、CFG：调整文本引导参数（αtxt）和说话人引导参数（αspk），用户能够控制语音的发音特征、口音强度等，进而定制更加个性化的语音输出。

4、PeRFlow：将生成过程分割成多个时间段，在每个时间段内进行快速计算，从而显著降低了采样步骤的数量。

## 环境配置
```
mv MegaTTS3_pytorch MegaTTS3 # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：e77c15729879
docker run -it --shm-size=64G -v $PWD/MegaTTS3:/home/MegaTTS3 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name tts <your IMAGE ID> bash
cd /home/MegaTTS3
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
sh ffmpeg_apt.sh # ffmpeg=4.4.4，若无法直接运行完成安装，可拷贝出来单独依次运行脚本中的命令，以避免网络不畅的问题。
```
### Dockerfile（方法二）
```
cd /home/MegaTTS3/docker
docker build --no-cache -t tts:latest .
docker run --shm-size=64G --name tts -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../MegaTTS3:/home/MegaTTS3 -it tts bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
sh ffmpeg_apt.sh # ffmpeg=4.4.4，若无法直接运行完成安装，可拷贝出来单独依次运行脚本中的命令，以避免网络不畅的问题。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.sourcefind.cn/tool/
```
DTK驱动:dtk2504
python:python3.10
torch:2.4.1
torchvision:0.19.1
triton:3.0.0
vllm:0.6.2
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.4.0
transformers:4.49.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/MegaTTS3
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
sh ffmpeg_apt.sh # ffmpeg=4.4.4，若无法直接运行完成安装，可拷贝出来单独依次运行脚本中的命令，以避免网络不畅的问题。
```

## 数据集
`无`

## 训练
无

## 推理
预训练权重目录结构：
```
/home/MegaTTS3/checkpoints/
    |── wavvae
    |── diffusion_transformer
    |── aligner_lm
    |── duration_lm
    ...
    └── g2p

mv MegaTTS3/* /home/MegaTTS3/checkpoints/ # MegaTTS3下的内容放到checkpoints目录下
``` 

### 单机单卡
```
cd /home/MegaTTS3
python tts/infer_cli.py --input_wav 'assets/Chinese_prompt.wav'  --input_text "另一边的桌上,一位读书人嗤之以鼻道,'佛子三藏,神子燕小鱼是什么样的人物,李家的那个李子夜如何与他们相提并论？'" --output_dir ./gen
```

更多资料可参考源项目中的[`readme_origin`](./readme_origin.md)。

## result
`输入: `
```
--input_wav assets/Chinese_prompt.wav
--input_text "另一边的桌上,一位读书人嗤之以鼻道,'佛子三藏,神子燕小鱼是什么样的人物,李家的那个李子夜如何与他们相提并论？'"
```

`输出:`
```
--output_dir gen/'[P]另一边的桌上,一位读书人嗤之以鼻道,'\''佛.wav'
```

官方效果示例：
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`语音合成`
### 热点应用行业
`广媒,影视,动漫,医疗,家居,教育`
## 预训练权重
HF/github下载地址为：[ByteDance/MegaTTS3](https://huggingface.co/ByteDance/MegaTTS3)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/MegaTTS3_pytorch.git
## 参考资料
- https://github.com/bytedance/MegaTTS3.git

