# Magma
具身智能新时代！VLA迎来最强基础模型Magma：UI导航、机器人操作全能。

## 论文
`Magma: A Foundation Model for Multimodal AI Agents`
- https://arxiv.org/pdf/2502.13130

## 模型结构
使用一个视觉编码器V，将每一帧图像编码成多个token，然后将所有token拼接成一个序列，并与编码任务描述的语言token一起输入到一个仅解码器的语言模型（LLM）中。
<div align=center>
    <img src="./doc/Magma.png"/>
</div>

## 算法原理
通过标记集合（SoM）和标记轨迹（ToM）技术，将视觉语言数据转化为可操作任务，显著提升了空间智能和任务泛化能力，能够理解和执行多模态任务，适用于数字和物理环境。

研究人员提出了一种简单、有效的方法，结合「标记集合」（Set-of-Mark, SoM）和「标记轨迹」（Trace-of-Mark, ToM）将模型扩展到空间预测任务（可点击按钮）和时间维度。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv Magma_pytorch Magma # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：dee41741fb40
docker run -it --shm-size=64G -v $PWD/Magma:/home/Magma -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name magma <your IMAGE ID> bash
cd /home/Magma
pip install -e . -i https://mirrors.aliyun.com/pypi/simple
pip install https://download.sourcefind.cn:65024/directlink/4/tensorflow/DAS1.5/tensorflow-2.13.1+das.opt1.dtk2504-cp310-cp310-linux_x86_64.whl -i https://mirrors.aliyun.com/pypi/simple # tensorflow=2.13.1
```
### Dockerfile（方法二）
```
cd /home/Magma/docker
docker build --no-cache -t magma:latest .
docker run --shm-size=64G --name magma -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../Magma:/home/Magma -it magma bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
pip install -e . -i https://mirrors.aliyun.com/pypi/simple
pip install https://download.sourcefind.cn:65024/directlink/4/tensorflow/DAS1.5/tensorflow-2.13.1+das.opt1.dtk2504-cp310-cp310-linux_x86_64.whl -i https://mirrors.aliyun.com/pypi/simple # tensorflow=2.13.1
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.sourcefind.cn/tool/
```
DTK驱动:dtk2504
python:python3.10
torch:2.4.1
torchvision:0.19.1
triton:3.0.0
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.4.0
transformers:4.49.0
tensorflow:2.13.1
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/Magma
pip install -e . -i https://mirrors.aliyun.com/pypi/simple
pip install https://download.sourcefind.cn:65024/directlink/4/tensorflow/DAS1.5/tensorflow-2.13.1+das.opt1.dtk2504-cp310-cp310-linux_x86_64.whl -i https://mirrors.aliyun.com/pypi/simple # tensorflow=2.13.1
```

bitsandbytes位于whl文件夹下，faiss、paddlepaddle可从可从光合开发者社区下载：
- https://download.sourcefind.cn:65024/directlink/4/faiss/DAS1.3/faiss-1.7.2+das.dtk24043-py3-none-any.whl
- https://download.sourcefind.cn:65024/directlink/4/paddle/DAS1.3/paddlepaddle-2.6.1+das.opt1.dtk24043-cp310-cp310-manylinux_2_28_x86_64.whl

## 数据集
`无`

## 训练
`无`

## 推理
预训练权重目录结构：
```
/home/Magma
    └── microsoft/Magma-8B

# 设置HF下载镜像：
export HF_ENDPOINT=https://hf-mirror.com

然后，运行推命令时，项目会自动下载模型：laion/CLIP-convnext_xxlarge-laion2B-s34B-b82K-augreg，下载完成后编码成缓存文件保存，此模型作者的代码无读取本地权重功能。
``` 

### 单机多卡
```
cd /home/Magma
python infer_transformers.py
```
更多资料可参考源项目中的[`README_origin`](./README_origin.md)。

## result
`输入: `
```
prompt: "What is the letter on the robot?"
image: "./assets/images/magma_logo.jpg"
```

`输出:`
```
response:  The letter on the robot is "M".
```
官方效果示例：

<div align=center>
    <img src="./doc/magma_mushroom.gif"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`具身智能`
### 热点应用行业
`制造,家居,医疗,能源,教育`
## 预训练权重
HF/github下载地址为：[microsoft/Magma-8B](https://huggingface.co/microsoft/Magma-8B)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/Magma_pytorch.git
## 参考资料
- https://github.com/microsoft/Magma.git

