# InfiniteYou
在灵活变换场景和内容的同时，精准保留你的身份特征，不只是简单的换脸。

## 论文
`InfiniteYou: Flexible Photo Recrafting While Preserving Your Identity`
- https://arxiv.org/pdf/2503.16418

## 模型结构
利用InfuseNet的残差连接将身份特征注入DiT基础模型，增强了身份相似性，同时保持生成能力。
<div align=center>
    <img src="./doc/structure.png"/>
</div>

## 算法原理
InfuseNet：InfuseNet 是 InfiniteYou 的核心组件，类似于 ControlNet，将身份特征注入扩散模型（如 FLUX）。身份特征基于残差连接注入到扩散模型中，避免直接修改注意力层，减少对基础模型生成能力的负面影响。

预训练阶段：基于真实单人单样本（SPSS）数据进行预训练，学习身份图像的重建能力。

监督微调阶段：基于合成的单人多样本（SPMS）数据进行微调，提升文本与图像对齐、图像质量和美学效果。

扩散变换器（Diffusion Transformers）：用先进的扩散变换器（如 FLUX）作为基础模型，模型在图像生成方面表现出色。扩散变换器支持生成高质量、高分辨率的图像，为身份保持图像生成提供了强大的基础。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv InfiniteYou_pytorch InfiniteYou # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：e77c15729879
docker run -it --shm-size=64G -v $PWD/InfiniteYou:/home/InfiniteYou -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name iy <your IMAGE ID> bash
cd /home/InfiniteYou
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
```
### Dockerfile（方法二）
```
cd /home/InfiniteYou/docker
docker build --no-cache -t iy:latest .
docker run --shm-size=64G --name iy -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../InfiniteYou:/home/InfiniteYou -it iy bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk2504
python:python3.10
torch:2.4.1
torchvision:0.19.1
triton:3.0.0
vllm:0.6.2
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.4.0
transformers:4.48.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/InfiniteYou
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
```

## 数据集
`无`

## 训练
无

## 推理
预训练权重目录结构：
```
/home/InfiniteYou
    |── ByteDance/InfiniteYou 
    |── black-forest-labs/FLUX.1-dev
    └── recognition_arcface_ir_se50.pth

mv recognition_arcface_ir_se50.pth /usr/local/lib/python3.10/dist-packages/facexlib/weights/ #将权重recognition_arcface_ir_se50放到facexlib库的weights目录下
``` 

### 单机多卡
```
cd /home/InfiniteYou
python test.py --id_image ./assets/examples/man.jpg --prompt "A man, portrait, cinematic" --out_results_dir ./results
```
更多资料可参考源项目中的[`README_origin`](./README_origin.md)。


## result
`输入: `
```
./assets/examples/man.jpg
```
<div align=center>
    <img src="./doc/input.png"/>
</div>

`输出:`
```
results/'00000_man_A man, portrait, cinematic_seed876627650.png'
```
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`AIGC`
### 热点应用行业
`零售,制造,电商,医疗,教育`
## 预训练权重
预训练权重快速下载中心：[SCNet AIModels](https://www.scnet.cn/ui/aihub/models) ，项目中的预训练权重可从快速下载通道下载：[ByteDance/InfiniteYou](https://gitlab.scnet.cn:9002/model/sugon_scnet/InfiniteYou.git)、[black-forest-labs/FLUX.1-dev](https://gitlab.scnet.cn:9002/model/icszy_zs_ai/FLUX.1-dev.git)

HF/github下载地址为：[ByteDance/InfiniteYou](https://huggingface.co/ByteDance/InfiniteYou)、[black-forest-labs/FLUX.1-dev](https://huggingface.co/black-forest-labs/FLUX.1-dev)、[facexlib-recognition_arcface_ir_se50](https://github.com/xinntao/facexlib/releases/download/v0.1.0/recognition_arcface_ir_se50.pth)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/InfiniteYou_pytorch.git
## 参考资料
- https://github.com/bytedance/InfiniteYou.git

