# Hunyuan3D-2
腾讯提出Hunyuan3D-2，用于生成带有高分辨率纹理贴图的高保真度3D模型。

## 论文
`无`
- 技术文档参考：[Hunyuan3D 2.0: Scaling Diffusion Models for High Resolution Textured 3D Assets Generation](./assets/report/Tencent_Hunyuan3D_2_0.pdf )

## 模型结构
Hunyuan3D-DiT采用了具有双流和单流块的 transformer 架构，是一种基于流的扩散模型，旨在根据给定的图像提示生成高保真和高分辨率的3D形状。
<div align=center>
    <img src="./doc/Hunyuan3DDiT.png"/>
</div>

Hunyuan3D-Paint通过双流图像条件参考网络、多任务注意力机制以及几何和视图条件策略，实现图像对齐、几何跟随和多视图一致性。
<div align=center>
    <img src="./doc/Hunyuan3DPaint.png"/>
</div>

## 算法原理
Hunyuan3D 2.0包括两个基础组件：一个大规模形状生成模型Hunyuan3D-DiT，和一个大规模纹理合成模型Hunyuan3D-Paint。形状生成模型基于可扩展的基于流的扩散变换器，旨在创建与给定条件图像正确对齐的几何形状，纹理合成模型基于生成的或手工制作的网格生成高分辨率和生动的纹理图。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv Hunyuan3D-2_pytorch Hunyuan3D-2 # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：b272aae8ec72
docker run -it --shm-size=64G -v $PWD/Hunyuan3D-2:/home/Hunyuan3D-2 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add hy2 --name hy2 <your IMAGE ID> bash
cd /home/Hunyuan3D-2
pip install -r requirements.txt

cd hy3dgen/texgen/custom_rasterizer
python3 setup.py install
cd ../../..
cd hy3dgen/texgen/differentiable_renderer
python3 setup.py install
```
### Dockerfile（方法二）
```
cd /home/Hunyuan3D-2/docker
docker build --no-cache -t hy2:latest .
docker run --shm-size=64G --name hy2 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../Hunyuan3D-2:/home/Hunyuan3D-2 -it hy2 bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。

cd hy3dgen/texgen/custom_rasterizer
python3 setup.py install
cd ../../..
cd hy3dgen/texgen/differentiable_renderer
python3 setup.py install
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04.3
python:python3.10
torch:2.3.0
torchvision:0.18.1
torchaudio:2.1.2
triton:2.1.0
vllm:0.6.2
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.3.0
xformers:0.0.25
transformers:4.48.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/Hunyuan3D-2
pip install -r requirements.txt

cd hy3dgen/texgen/custom_rasterizer
python3 setup.py install
cd ../../..
cd hy3dgen/texgen/differentiable_renderer
python3 setup.py install
```

## 数据集
`无`

## 训练
`无`

## 推理
### 单机单卡
预训练权重目录结构：
```
/home/Hunyuan3D-2/
    ├── tencent/Hunyuan3D-2/
        ├── hunyuan3d-delight-v2-0
        ├── hunyuan3d-dit-v2-0
        ├── hunyuan3d-dit-v2-0-fast
        ...
        └── hunyuan3d-paint-v2-0
    ├── tabilityai/stable-diffusion-x4-upscaler
    └── u2net.onnx
mv u2net.onnx /root/.u2net/
```

```
python minimal_demo.py
# 目前DCU仅支持3D形状生成，其它功能敬请期待后续开放。
```

更多资料可参考源项目的[`README_origin`](./README_origin.md)

## result

`输入: `
```
图片: assets/demo.png
```
`输出:`
```
3D结构: mesh.glb
```
在线3D模型结构查看工具：[gltf-viewer](https://gltf-viewer.donmccurdy.com/) 

源作者提供的效果示例：

<div align=center>
  <img src="assets/images/e2e-1.gif"  height=250>
  <img src="assets/images/e2e-2.gif"  height=250>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`3D生成`
### 热点应用行业
`动漫,广媒,影视,制造,医疗,家居,教育`
## 预训练权重
预训练权重快速下载中心：[SCNet AIModels](http://113.200.138.88:18080/aimodels) ，项目中的预训练权重可从快速下载通道下载：[Hunyuan3D-2](http://113.200.138.88:18080/aimodels/tencent/hunyuan3d-2-hf.git)、[stable-diffusion-x4-upscaler](http://113.200.138.88:18080/aimodels/stable-diffusion-x4-upscaler.git)、[rembg-u2net](http://113.200.138.88:18080/aimodels/findsource-dependency/rembg-u2net.git)

Hugging Face下载地址为：[Hunyuan3D-2](https://huggingface.co/tencent/Hunyuan3D-2)、[stable-diffusion-x4-upscaler](https://huggingface.co/stabilityai/stable-diffusion-x4-upscaler)、[rembg-u2net](https://github.com/danielgatis/rembg/releases/download/v0.0.0/u2net.onnx)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/Hunyuan3D-2_pytorch.git
## 参考资料
- https://github.com/Tencent/Hunyuan3D-2.git

