# Direct3D
Neural4D 2.0将3D AI的生成效果提升至“人工级水平”，算力需求暴降80%，DreamTech已开源其前期研究成果Neural4D 1.0（本项目）。

## 论文
`Direct3D: Scalable Image-to-3D Generation via 3D Latent Diffusion Transformer`
- https://arxiv.org/pdf/2405.14832

## 模型结构
Neural4D 1.0包含两个关键组件，D3D-VAE用于捕捉3D形状的关键特征，然后D3D-DiT利用像素级和语义级对齐模块，整合图像信息到扩散过程中。
<div align=center>
    <img src="./doc/Direct3D.png"/>
</div>

## 算法原理
Neural4D 1.0采用3D生成的通用方案，先获取形状信息，再加入像素级细节信息，而暂未开源的Neural4D 2.0引入了全新的3D Assembly Generation思路，模拟真实世界的3D拓扑结构与人类设计师分部件三维建模的思路，并引入类似DeepSeek-R1的强化学习策略。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv Direct3D_pytorch Direct3D # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：b272aae8ec72
docker run -it --shm-size=64G -v $PWD/Direct3D:/home/Direct3D -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name d3d <your IMAGE ID> bash
cd /home/Direct3D
pip install -r requirements.txt
pip install -e .
```
### Dockerfile（方法二）
```
cd /home/Direct3D/docker
docker build --no-cache -t d3d:latest .
docker run --shm-size=64G --name d3d -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../Direct3D:/home/Direct3D -it d3d bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
cd /home/Direct3D
pip install -e .
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04.3
python:python3.10
torch:2.3.0
torchvision:0.18.1
torchaudio:2.1.2
triton:2.1.0
vllm:0.6.2
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.3.0
xformers:0.0.25
transformers:4.48.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/Direct3D
pip install -r requirements.txt
pip install -e .
```

## 数据集
`无`

## 训练
`无`

## 推理
### 单机单卡
预训练权重目录结构：
```
/home/Direct3D/
    ├── DreamTechAI/Direct3D
    ├── openai/clip-vit-large-patch14
    └── facebook/dinov2-large
```

```
python test.py
```

更多资料可参考源项目的[`README_origin`](./README_origin.md)

## result

`输入: `
```
图片: assets/devil.png
```
`输出:`
```
3D结构: output.obj
```
在线3D模型结构查看工具：[lzz3Dview](https://stl.neurosurgery.icu/) 

源作者提供的效果示例：

<div align=center>
  <img src="assets/demo/video2.gif", width="48%">
  <img src="assets/demo/video1.gif", width="48%">
  <br>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`3D生成`
### 热点应用行业
`动漫,广媒,影视,制造,医疗,家居,教育`
## 预训练权重
预训练权重快速下载中心：[SCNet AIModels](http://113.200.138.88:18080/aimodels) ，项目中的预训练权重可从快速下载通道下载：[Direct3D](http://113.200.138.88:18080/aimodels/dreamtechai/Direct3D.git)、[clip-vit-large-patch14](http://113.200.138.88:18080/aimodels/clip-vit-large-patch14.git)、[dinov2-large](http://113.200.138.88:18080/aimodels/facebook/dinov2-large.git)

Hugging Face下载地址为：[Direct3D](https://huggingface.co/DreamTechAI/Direct3D)、[clip-vit-large-patch14](https://huggingface.co/openai/clip-vit-large-patch14)、[dinov2-large](https://huggingface.co/facebook/dinov2-large)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/Direct3D_pytorch.git
## 参考资料
- https://github.com/DreamTechAI/Direct3D.git

