# DeepSeek-VL2

## 论文

`DeepSeek-VL2: Mixture-of-Experts Vision-Language Models for Advanced Multimodal Understanding`

* https://arxiv.org/abs/2412.10302


## 模型结构

DeepSeek-VL2 由三个核心模块组成：视觉编码器、视觉语言适配器和混合专家 (MoE) 语言模型。DeepSeek-VL2 在其前身 DeepSeek-VL 的仅解码器 LLaVA 风格架构的基础上引入了两项重大改进：动态拼接策略和具有多头潜在注意力 的 DeepSeekMOE 语言模型。 这些创新使得能够更有效地处理高分辨率视觉输入和文本数据。

![alt text](images/arch.png)

## 算法原理

DeepSeek-VL2 的语言模型基于 DeepSeekMoE，它结合了多头潜在注意力机制。 MLA 通过将键值缓存压缩为潜在向量来提高推理效率，从而实现更高的吞吐量能力。 该模型还结合了 MoE 架构，允许通过稀疏计算进行高效推理。 在 MoE 训练期间，DeepSeek-VL2 为每个专家引入一个全局偏差项，以经济高效地改善专家之间的负载平衡。在视觉语言对齐阶段，主要目标是建立视觉特征和语言特征之间的稳固连接。这种对齐使预训练的语言模型能够有效地处理视觉输入。与之前保持固定预训练视觉编码器和语言模型的方法不同，DeepSeek-VL2 调整了固定分辨率的视觉编码器以适应动态高分辨率图像。在此阶段，DeepSeek-VL2 优化了视觉编码器和视觉语言适配器，同时保持语言模型冻结。

![alt text](images/theory.png)


## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04

    docker run --shm-size 500g --network=host --name=dpvl2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash
    

    # 部署模型环境
    
    cd ./project_path

    pip install -e .


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 500g --network=host --name=dpvl2 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    cd ./project_path
    
    pip install -e .


## 数据集

无

## 训练

无

## 推理

```
CUDA_VISIBLE_DEVICES=0 python inference.py --model_path "DeepSeek-VL2/deepseek-vl2-tiny/"
```

## result

![alt text](images/result.png)

### 精度

无

## 应用场景

### 算法类别

`图像理解`

### 热点应用行业

`电商,教育,广媒,交通，政府`

## 预训练权重

[SCNet高速下载通道]
* [Deepseek Vl2](http://113.200.138.88:18080/aimodels/deepseek-ai/deepseek-vl2)
* [Deepseek Vl2 Small](http://113.200.138.88:18080/aimodels/deepseek-ai/deepseek-vl2-small)
* [Deepseek Vl2 Tiny](http://113.200.138.88:18080/aimodels/deepseek-ai/deepseek-vl2-tiny)


## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/deepseek-vl2_pytorch

## 参考资料

* https://github.com/deepseek-ai/DeepSeek-VL2
