# DeepSeek-R1

## 论文

`DeepSeek-R1: Incentivizing Reasoning Capability in LLMs via Reinforcement Learning`

* https://github.com/deepseek-ai/DeepSeek-R1/blob/main/DeepSeek_R1.pdf


## 模型结构

该模型基于Transformer，采用Multi-Head Latent Attention和DeepSeekMoE架构，其中MLA通过减少KV缓存降低内存占用可用于高效推理，DeepSeekMoE通过auxiliary loss平衡专家负载。

![alt text](readme_imgs/arch.png)

## 算法原理

DeepSeek-R1的模型结构通过MLA、DeepSeekMoE、辅助损失无关的负载均衡策略、多令牌预测和FP8混合精度训练等创新技术，显著提升了模型的性能和训练效率，使用强化学习训练模型，增强模型的思考能力，这些设计使得DeepSeek-R1在保持高性能的同时，大幅降低了训练成本。


## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-py3.10-dtk24.04.3-ubuntu20.04

    docker run --shm-size 500g --network=host --name=dpskr1 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash
    

    # 部署模型环境
    
    cd inference
    pip install -r requirements.txt


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 500g --network=host --name=dpskr1 --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    cd inference
    pip install -r requirements.txt


## 数据集

无

## 训练

无

## 推理

### 配置ollama环境

```
git clone -b 0.5.7 http://developer.sourcefind.cn/codes/OpenDAS/ollama.git

cd ollama

# 编译

wget https://go.dev/dl/go1.23.4.linux-amd64.tar.gz
tar -C /usr/local -xzf go1.23.4.linux-amd64.tar.gz
export PATH=$PATH:/usr/local/go/bin

# 修改go下载源，提升速度（按需设置）
go env -w GOPROXY=https://goproxy.cn,direct

# 运行编译

export LIBRARY_PATH=/opt/dtk/lib:$LIBRARY_PATH
make -j 16
go build .
```

### run

#### deepseek-r1 模型推理  其它模型参考 [ollama.com](https://ollama.com/library)

##### 启用服务端 (server)
```
export HSA_OVERRIDE_GFX_VERSION=设备型号（如: gfx906对应9.0.6；k100ai gfx928对应9.2.8）

# 例如 export HSA_OVERRIDE_GFX_VERSION=9.2.8

export ROCR_VISIBLE_DEVICES=所有设备号（0,1,2,3,4,5,6,...）/选择设备号

# 例如 export ROCR_VISIBLE_DEVICES=0, 1, 2, 3, 4


./ollama serve

```
##### 启用应用端 (chat)

新建终端，进入容器


```
cd  ollama

./ollama run deepseek-r1:671b
```


## result

![alt text](readme_imgs/result1.png)

### 精度

无

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`电商,教育,广媒,交通，政府`

## 预训练权重

[SCNet高速下载通道](http://113.200.138.88:18080/aimodels/deepseek-ai/DeepSeek-R1-GGUF)


## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/deepseek-r1_ollama

## 参考资料

* https://github.com/deepseek-ai/DeepSeek-R1

* https://github.com/ollama/ollama
