# DB-GPT
用自然语言直接查数据库，DB-GPT具备生成高精度和复杂SQL的能力，简化大模型在数据库应用中的开发，支持数据处理、问答、RAG等功能，适用于数据3.0时代的高效应用构建。

## 论文
`无`

## 模型结构
DB-GPT架构：
<div align=center>
    <img src="./doc/dbgpt.png"/>
</div>

本步骤以目前最新模型QwQ32B为例，其它模型读者可以此类推进行研究，QwQ-32B采用transformer通用的Decoder-only结构。
<div align=center>
    <img src="./doc/qwen.png"/>
</div>

## 算法原理
强大的基础模型+大规模强化学习=强大的推理能力，这是当前大语言模型训练的有效新方向。除了基础推理能力外，QwQ-32B还集成了与Agent相关的能力，使其能够在使用工具的同时进行批判性思考，并根据环境反馈调整推理过程。

作者暂未公布具体采用的何种强化学习算法，若为GRPO，原理如下：

算法核心点：通过反向KL散度约束，GRPO实现了更稳定的策略更新。与TRPO的硬约束不同，采用软约束形式，既能保证训练稳定性，又避免了复杂的二阶优化计算，β负责动态调节探索与利用的平衡系数。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

<div align=center>
    <img src="./doc/GRPO.png"/>
</div>

GRPO算法工作流程：
<div align=center>
    <img src="./doc/GRPO_flow.png"/>
</div>


## 环境配置
```
mv DB-GPT_pytorch DB-GPT # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：e77c15729879
docker run -it -p 5670:5670 --shm-size=64G -v $PWD/DB-GPT:/home/DB-GPT -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name dbgpt <your IMAGE ID> bash
cd /home/DB-GPT
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
```
### Dockerfile（方法二）
```
cd /home/DB-GPT/docker
docker build --no-cache -t dbgpt:latest .
docker run -p 5670:5670 --shm-size=64G --name dbgpt -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../DB-GPT:/home/DB-GPT -it dbgpt bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
cd /home/DB-GPT
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple # 根据项目DB-GPT中的文件安装需要的库。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.sourcefind.cn/tool/
```
DTK驱动:dtk2504
python:python3.10
torch:2.4.1
torchvision:0.19.1
triton:3.0.0
vllm:0.6.2
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.4.0
transformers:4.49.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/DB-GPT
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
```

由于本项目功能特别多，此步骤仅供部分功能示例，若需更多功能体验，其环境配置可参考源项目中的[`README_origin`](./README_origin.md)借鉴本文档的步骤说明自行研究使用。 

体验其它功能需要的python库可通过以下两种方法补充：
```
# 方法一：
pip install xxx
# 方法二：
uv pip install xxx --default-index=https://mirrors.aliyun.com/pypi/simple --system
```

## 数据集
`无`

## 训练
无

## 推理
预训练权重目录结构：
```
/home/DB-GPT
    ├── BAAI/bge-large-zh-v1.5
    └── Qwen/QwQ-32B
``` 

### 单机多卡
```
dbgpt start webserver --config configs/dbgpt-local-qwq32b.toml # 本步骤以QwQ-32B为例，其它模型的使用方法依次类推，可参考其github源项目的issue解决项目bug。
```

## result
本地浏览器打开地址访问在线操作页面：http://localhost:5670/
<div align=center>
    <img src="./doc/page1.png"/>
</div>

`输入: `
```
美国多少人口
```
<div align=center>
    <img src="./doc/page2.png"/>
</div>

`输出:`
```
截至2023年12月，美国人口的最新估算约为 3.36亿（336,000,000）。这一数据基于美国人口普查局（U.S. Census Bureau）的实时人口钟（Population Clock）动态估算，会随出生、死亡、移民等因素持续更新。
```
<div align=center>
    <img src="./doc/page3.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`对话问答`
### 热点应用行业
`制造,广媒,金融,能源,医疗,家居,教育`
## 预训练权重

HF/魔搭社区下载地址为：[bge-large-zh-v1.5](https://huggingface.co/BAAI/bge-large-zh-v1.5)、[QwQ-32B](https://www.modelscope.cn/models/Qwen/QwQ-32B)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/DB-GPT_pytorch.git
## 参考资料
- https://github.com/eosphoros-ai/DB-GPT.git
- http://docs.dbgpt.cn/docs/quickstart

