# ChatGLM3-6B

## 论文
`GLM: General Language Model Pretraining with Autoregressive Blank Infilling`
- [https://arxiv.org/abs/2103.10360](https://arxiv.org/abs/2103.10360)

## 模型结构
ChatGLM3 是智谱AI和清华大学 KEG 实验室联合发布的新一代对话预训练模型。ChatGLM3-6B 是 ChatGLM3 系列中的开源模型，在保留了前两代模型对话流畅、部署门槛低等众多优秀特性的基础上，ChatGLM3-6B的基础模型ChatGLM3-6B-Base 采用了更多样的训练数据、更充分的训练步数和更合理的训练策略。

ChatGLM3-6B同样采用Transformer模型结构：

<div align="center">
<img src="./media/transformers.jpg" width="300" height="400">
</div>

以下是ChatGLM2-6B的主要网络参数配置：


| 模型名称 | 隐含层维度 | 层数 | 头数 | 词表大小 | 位置编码 | 最大长 |
| -------- | -------- | -------- | -------- | -------- | -------- | -------- | 
|ChatGLM3-6B | 4,096 | 28 | 32 | 65024 |  RoPE | 8192 |


## 算法原理
模型基于 [General Language Model (GLM)](https://github.com/THUDM/GLM) 架构，GLM是一种基于Transformer的语言模型，以自回归空白填充为训练目标，同时具备自回归和自编码能力。

<div align="center">
<img src="./media/GLM.png" width="550" height="200">
</div>


## 环境配置

### Docker(方式一)
推荐使用docker方式运行，提供拉取的docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py38-latest
```

进入docker，安装docker中没有的依赖:
```
docker run -dit --network=host --name=chatglm3 --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py38-latest
docker exec -it chatglm3 /bin/bash
pip install -4 requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```
### Dockerfile(方式二)
```
docker build -t chatglm3:latest .
docker run -dit --network=host --name=chatglm3 --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 chatglm3:latest
docker exec -it chatglm3 /bin/bash
```

### Conda（方法三）
1. 创建conda虚拟环境：
```
conda create -n chatglm python=3.8
```

2. 关于本项目DCU显卡所需的工具包、深度学习库等均可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
- [DTK 23.04](https://cancon.hpccube.com:65024/1/main/DTK-23.04.1)
- [Pytorch 1.13.1](https://cancon.hpccube.com:65024/4/main/pytorch/dtk23.04)
- [Deepspeed 0.9.2](https://cancon.hpccube.com:65024/4/main/deepspeed/dtk23.04)

    Tips：以上dtk驱动、python、deepspeed等工具版本需要严格一一对应。

3. 其它依赖库参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
本仓库以 [ADGEN](https://aclanthology.org/D19-1321.pdf) (广告生成) 数据集为例介绍代码的使用方法，该数据集任务为根据输入（content）生成一段广告词（summary），以下为下载地址：
- [Google Drive](https://drive.google.com/file/d/13_vf0xRTQsyneRKdD1bZIr93vBGOczrk/view?usp=sharing) 或者 [Tsinghua Cloud](https://cloud.tsinghua.edu.cn/f/b3f119a008264b1cabd1/?dl=1)
下载处理好的 ADGEN 数据集，将解压后的AdvertiseGen目录放到 [finetune_chatmodel_demo](./finetune_chatmodel_demo)目录下。数据集目录结构如下：
```
 ── AdvertiseGen
    │   ├── dev.json
    │   └── train.json
```
通过以下方式将数据集处理成模型需要的格式:
```bash
cd finetune_chatmodel_demo
python ./scripts/format_advertise_gen.py --path "AdvertiseGen/train.json"
```

### 模型下载
| Model | Seq Length |                                                              Download                                                               
| :---: |:---------------------------:|:-----------------------------------------------------------------------------------------------------------------------------------:
| ChatGLM3-6B | 8k |      [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b)      
| ChatGLM3-6B-Base | 8k | [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b-base) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b-base) 
| ChatGLM3-6B-32K | 32k |                                   [HuggingFace](https://huggingface.co/THUDM/chatglm3-6b-32k) \| [ModelScope](https://modelscope.cn/models/ZhipuAI/chatglm3-6b-32k) 

## 训练

### P-tuning v2 微调训练
本仓库实现了对于ChatGLM3-6B模型基于[P-Tuning v2](https://github.com/THUDM/P-tuning-v2)的微调。P-Tuning v2是由清华大学提出的一种高效参数微调方法。

#### 单机多卡训练
```
    cd ./finetune_chatmodel_demo/scripts
    bash finetune_pt.sh
```
注意：请根据自己的需求配置其中的模型路径、数据集路径、batchsize、学习率等参数；


### Finetune全参数微调

#### 单机多卡训练
```
    cd ./finetune_chatmodel_demo/scripts
    bash finetune_ds.sh
```
注意：请根据自己的需求配置其中的模型路径、数据集路径、batchsize、学习率等参数；


### 推理验证
对于输入输出格式的微调，可使用 `inference.py` 进行基本的推理验证。

```bash
python inference.py \
    --pt-checkpoint "path to p-tuning checkpoint" \
    --model THUDM/chatglm3-6b 
```

```bash
python inference.py \
    --tokenizer THUDM/chatglm3-6b \
    --model "path to finetuned model checkpoint" 
```


## 推理
运行如下命令：

    python ./basic_demo/cli_demo.py

程序会在命令行中进行交互式的对话，在命令行中输入指示并回车即可生成回复，输入 clear 可以清空对话历史，输入 stop 终止程序。


## Result
- 推理效果如下：
<div align="center">
<img src="./media/cli.png" width="650" height="100">
</div>

### 精度
无


## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`医疗,教育,科研,金融`

## 源码仓库及问题反馈

- https://developer.hpccube.com/codes/modelzoo/chatglm3-6b_pytorch

## 参考

- [THUDM/ChatGLM3-6B](https://github.com/THUDM/ChatGLM3)

