#pragma once

#include <string.h>
#include "base.h"
#include "net.h"
#include "hardware_utils.h"

namespace sccl {
namespace hardware {
namespace topology {

#define SCCL_TOPO_NODE_TYPES (6)        // 硬件node的类型
#define SCCL_TOPO_MAX_NODE_PER_TYPE (4) // 每个硬件node类型中节点的数量，间接表明网络拓扑结构的最大层数
#define SCCL_TOPO_RANK_MAX_LINKS (8)    // 每个rank中节点与当前rank中其他节点的链接数量

// 定义 topoPathType_t 枚举类型，用于表示不同的路径类型。
enum topoPathType {
    PATH_LOC = 0, // 本地路径
    PATH_NVL = 1, // 通过 NVLink 连接
    PATH_NVB = 2, // 通过中间 GPU 使用 NVLink 连接
    PATH_PIX = 3, // 通过最多一个 PCIe 桥连接
    PATH_PXB = 4, // 通过多个 PCIe 桥连接（不经过 PCIe 主桥）
    PATH_PXN = 5, // GPU 和 NIC 之间通过中间 GPU 连接
    PATH_PHB = 6, // 通过 PCIe 以及 PCIe 主桥连接
    PATH_SYS = 7, // 通过 PCIe 以及 NUMA 节点之间的 SMP 互连连接
    PATH_NET = 8, // 通过网络连接
    PATH_DIS = 9  // 断开连接
};

////////////////////////////////////////////////////////////////////////////////////////////////

// // 定义拓扑节点的结构体
// struct scclTopoNode;

// // 定义拓扑链接的结构体
// struct scclTopoLink {
//     int type;                     // 链接类型
//     float bw;                     // 带宽
//     struct scclTopoNode* remNode; // 远程节点指针
// };
// // 用于表示一组拓扑节点
// struct scclTopoNodeSet {
//     int count;                                              // 节点数量
//     struct scclTopoNode nodes[SCCL_TOPO_MAX_NODE_PER_TYPE]; //
// };
// // struct scclTopoNodeSet nodes[SCCL_TOPO_NODE_TYPES];

//     //// 计算直接相连的nodes信息
//     int nlinks;                                          // 链接数量
//     struct scclTopoLink links[SCCL_TOPO_RANK_MAX_LINKS]; // rank内部直接相连的其他node的链接列表

////////////////////////////////////////////////////////////////////////////////////////////////
scclResult_t scclTopoGetStrFromSys(const char* path, const char* fileName, char* strValue);

// 将64位整数转换为总线ID字符串
scclResult_t int64ToBusId(int64_t id, char* busId);

// 将总线ID字符串转换为64位整数
scclResult_t busIdToInt64(const char* busId, int64_t* id);

// 将PCI路径转换为64位整数，路径偏移量和最小偏移量作为参数
scclResult_t pciPathToInt64(char* path, int offset, int minOffset, int64_t* id);

} // namespace topology
} // namespace hardware
} // namespace sccl
