#pragma once

#include <string.h>
#include "base.h"
#include "socket.h"
#include "bootstrap_utils.h"
#include "bootstrap_net.h"
#include "thread_pool.h"
#include "ipc_socket.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace bootstrap {

typedef class sccl::hardware::net::ipc_socket::scclIpcSocket scclIpcSocket_t;

///////////////////////////////////// 用于初始化时的功能函数 //////////////////////////////////////////
scclResult_t bootstrapGetUniqueId(struct BootstrapHandle* handle);
scclResult_t bootstrapCreateRoot(struct BootstrapHandle* handle);

///////////////////////////////////// 用于初始化时的类 //////////////////////////////////////////
class Bootstrap {
public:
    Bootstrap(const struct BootstrapHandle*, int rank, int nRanks);
    ~Bootstrap();

    // 初始化bootstrap通信环境
    scclResult_t init(struct BootstrapComm* bootstrap_comm);

    // 广播节点信息
    scclResult_t bootstrapAllGather(struct scclNodeInfo*);

private:
    // 创建根节点的数据广播
    scclResult_t bootstrapRootGatherAndBroadcast(void* send_data, void* recv_data);

    // 初始化唯一ID信息结构体
    scclResult_t bootstrapCommInitNodeInfo(scclNet_t* scclNet, struct scclNodeInfo* node_info);

    // scclResult_t bootstrapGetAllNodes(const struct scclNodeInfo* , struct BootstrapComm* comm);

private:
    int rank, nRanks;             // 初始化阶段获取MPI的值
    int localRank, nLocalRanks;   // 通过bootstrapRootGatherAndBroadcast函数确定值
    volatile uint32_t* abortFlag; // 中止标志，非阻塞套接字设置

    // 外部传入的0号节点的基础信息
    const struct BootstrapHandle* root_handle;

    // 初始化标志
    bool socketInitDone;
    // 互斥锁，用于保护初始化过程的线程安全
    pthread_mutex_t bootstrapMutex = PTHREAD_MUTEX_INITIALIZER;
    pthread_cond_t bootstrapCond   = PTHREAD_COND_INITIALIZER;

    // 标志是否已经初始化
    // 线程池变量
    int max_pthreads               = 0;       // 用于存储最大并行线程数的整型变量
    class ThreadPool* pthread_pool = nullptr; // 指向ThreadPool类实例的指针，初始值为nullptr
    scclIpcSocket_t* ipcsocket     = nullptr; // 指向scclIpcSocket类实例的指针，初始值为nullptr
    scclSocket_t* my_listen_sock   = nullptr; // 指向scclSocket类实例的指针，初始值为nullptr
};

} // namespace bootstrap
} // namespace topology
} // namespace hardware
} // namespace sccl
