#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#define SOCKET_PATH "/tmp/socket.domain"

void err_quit(const char* estr) {
    perror(estr);
    exit(-1);
}

int main(int argc, char* argv[]) {
    char buf[1024] = {0};                 // 用于存储从服务器读取的数据或要发送给服务器的数据
    int sockfd     = -1;                  // 用于存储创建的套接字文件描述符
    int rv         = -1;                  // 用于存储函数返回值
    struct sockaddr_un servaddr;          // 用于存储服务器地址信息
    socklen_t addrlen = sizeof(servaddr); // 服务器地址长度

    // 创建UNIX域套接字
    if((sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
        err_quit("socket create failure"); // 如果创建失败，调用err_quit函数并传递错误信息
    }

    printf("Create sockfd[%d] ok\n", sockfd); // 打印创建的套接字文件描述符

    bzero(&servaddr, sizeof(servaddr)); // 将服务器地址结构体清零

    servaddr.sun_family = AF_UNIX;                                          // 设置地址族为UNIX
    strncpy(servaddr.sun_path, SOCKET_PATH, sizeof(servaddr.sun_path) - 1); // 设置服务器地址路径

    // 连接到服务器
    if(connect(sockfd, (struct sockaddr*)&servaddr, addrlen) < 0)
        printf("Connect to unix domain socket server on \"%s\" failure:%s\n", SOCKET_PATH, strerror(errno)); // 如果连接失败，打印错误信息

    printf("connect unix domain socket \"%s\" ok!\n", SOCKET_PATH); // 打印连接成功信息

    fgets(buf, sizeof(buf), stdin); // 从标准输入读取数据

    // 向服务器写入数据
    if((rv = write(sockfd, buf, strlen(buf))) < 0) {
        printf("Write to server failure:%s\n", strerror(errno)); // 如果写入失败，打印错误信息
        close(sockfd);                                           // 关闭套接字
        return -1;                                               // 返回错误码
    }

    printf("Actually write %d bytes data to server:%s\n", rv - 1, buf); // 打印实际写入的数据量和数据内容

    bzero(&buf, sizeof(buf)); // 清空缓冲区
    printf("start read\n");   // 打印开始读取信息

    // 从服务器读取数据
    if((rv = read(sockfd, buf, sizeof(buf))) < 0) {
        printf("Read to server failure:%s\n", strerror(errno)); // 如果读取失败，打印错误信息
        close(sockfd);                                          // 关闭套接字
        return -1;                                              // 返回错误码
    }

    else if(0 == rv) {
        printf("socket connet disconnected\n"); // 如果连接断开，打印断开信息
        close(sockfd);                          // 关闭套接字
        return -3;                              // 返回错误码
    }

    printf("Read %d bytes data from server:%s\n", rv - 1, buf); // 打印实际读取的数据量和数据内容

    close(sockfd); // 关闭套接字

    return 0; // 返回成功码
}
