#pragma once

#include <pthread.h>
#include <queue>
#include <utility>

// 定义一个任务结构体，用于线程池中的任务队列
struct Task {
    // 成员函数指针，指向一个接受void*参数并返回void*的函数
    void* (*f)(void*);

    // 成员变量，用于存储传递给函数的参数
    void* arg;

    // 构造函数，用于初始化任务，接受一个函数指针和一个参数
    Task(void* (*f)(void*), void* arg) {
        this->f   = f;   // 初始化成员函数指针
        this->arg = arg; // 初始化成员变量
    }

    // 默认构造函数，不进行初始化
    Task() {}
};

class Task_Queue {
public:
    Task_Queue();  // 构造函数
    ~Task_Queue(); // 析构函数

    // 添加任务到队列中，参数为任务函数和其参数，返回值表示添加是否成功
    bool add_task(void* f(void*), void* arg);

    // 从队列中提取任务，返回值为任务和一个布尔值，表示提取是否成功
    std::pair<Task, bool> extract_task();

    // 尝试从队列中提取任务，不阻塞，返回值为任务和一个布尔值，表示提取是否成功
    std::pair<Task, bool> try_extract_task();

    // 获取当前队列中的任务数量
    unsigned int size();

    // 销毁任务队列，清理资源
    void destroy();

private:
    std::queue<Task> tasks;    // 任务队列，存储任务对象
    pthread_mutex_t task_lock; // 用于线程同步的互斥锁
    pthread_cond_t task_cond;  // 用于线程同步的条件变量
    bool shutdown;             // 标志位，用于指示队列是否关闭
};
