#pragma once

#include <hip/hip_runtime_api.h>
#include <hip/hip_fp16.h>

/**
 * @brief 对选中的代码进行简要功能说明
 * @note 根据代码作用域（如公开API或内部实现）编写适当的文档注释
 */
typedef enum {
    scclSuccess           = 0, /*!< 无错误 */
    scclUnhandledHipError = 1, /*!< 未处理的 HIP 错误 */
    scclSystemError       = 2, /*!< 未处理的系统错误 */
    scclInternalError     = 3, /*!< 内部错误 - 请报告给 RCCL 开发者 */
    scclInvalidArgument   = 4, /*!< 无效参数 */
    scclInvalidUsage      = 5, /*!< 无效使用 */
    scclRemoteError       = 6, /*!< 远程进程退出或发生网络错误 */
    scclInProgress        = 7, /*!< RCCL 操作正在进行中 */
    scclNumResults        = 8  /*!< 结果类型数量 */
} scclResult_t;
