#pragma once

#include <vector>
#include "base.h"
#include "graph_utils.h"
#include "paths.h"

namespace sccl {
namespace hardware {
namespace topology {
namespace graph {

class Graph {
public:
    Graph(const Bootstrap* bootstrap);
    virtual ~Graph();

    scclResult_t establishGraph(const BootstrapComm_t* bootstrap_comm);

    // 通信路径计算
    scclResult_t calculateCommunicationPaths(const BootstrapComm_t* bootstrap_comm, scclTopoGraph_t* topo_graph);

    // 逻辑拓扑构建
    scclResult_t searchLogicalTopology();

    // 根据无向图计算topo路径
    scclResult_t calculateTopoChannels();

private:
    // 额外处理nRanks个nodes的连接关系
    scclResult_t bootstrapNodesLink(void* node_info_vec, int node_info_total_bytes);

private:
    const Bootstrap* sccl_bootstrap; // 为了调用class Bootstrap中的函数

    // 记录所有rank中node信息
    std::vector<char> node_info_vec;  // 实际为std::vector<scclNodeInfo_t>，vector不支持scclNodeInfo_t变长
    size_t node_info_total_bytes = 0; // 记录可变长度scclNodeInfo_t类型数据的实际大小

    std::vector<std::vector<int>> adjacencyMatrix; // 使用邻接矩阵表示图

    // rank信息
    int rank, nRanks;
    int localRank, nLocalRanks;
    int interRank, nInterRanks; // 整个节点在全部节点中的位置
};

} // namespace graph
} // namespace topology
} // namespace hardware
} // namespace sccl
