#pragma once

#include <infiniband/verbs.h>
#include <sys/types.h>
#include <unistd.h>

#include "base.h"
#include "ibvsymbols.h"

namespace sccl {
namespace hardware {
namespace net {
namespace net_ib {

typedef enum ibv_return_enum : uint8_t {
    IBV_SUCCESS = 0, //!< The operation was successful
} ibv_return_t;

// 包装ibv符号初始化
scclResult_t wrap_ibv_symbols(void);

// 包装ibv函数的SCCL初始化
scclResult_t wrap_ibv_fork_init(void);

// 获取设备列表
scclResult_t wrap_ibv_get_device_list(struct ibv_device*** ret, int* num_devices);

// 释放设备列表
scclResult_t wrap_ibv_free_device_list(struct ibv_device** list);

// 获取设备名称
const char* wrap_ibv_get_device_name(struct ibv_device* device);

// 打开设备
scclResult_t wrap_ibv_open_device(struct ibv_context** ret, struct ibv_device* device);

// 关闭设备
scclResult_t wrap_ibv_close_device(struct ibv_context* context);

// 获取异步事件
scclResult_t wrap_ibv_get_async_event(struct ibv_context* context, struct ibv_async_event* event);

// 确认异步事件
scclResult_t wrap_ibv_ack_async_event(struct ibv_async_event* event);

// 查询设备属性
scclResult_t wrap_ibv_query_device(struct ibv_context* context, struct ibv_device_attr* device_attr);

// 查询端口属性
scclResult_t wrap_ibv_query_port(struct ibv_context* context, uint8_t port_num, struct ibv_port_attr* port_attr);

// 查询GID
scclResult_t wrap_ibv_query_gid(struct ibv_context* context, uint8_t port_num, int index, union ibv_gid* gid);

// 查询QP属性
scclResult_t wrap_ibv_query_qp(struct ibv_qp* qp, struct ibv_qp_attr* attr, int attr_mask, struct ibv_qp_init_attr* init_attr);

// 分配保护域（PD）
scclResult_t wrap_ibv_alloc_pd(struct ibv_pd** ret, struct ibv_context* context);

// 释放保护域（PD）
scclResult_t wrap_ibv_dealloc_pd(struct ibv_pd* pd);

// 注册内存区域（MR）
scclResult_t wrap_ibv_reg_mr(struct ibv_mr** ret, struct ibv_pd* pd, void* addr, size_t length, int access);

// 直接注册内存区域（MR）
struct ibv_mr* wrap_direct_ibv_reg_mr(struct ibv_pd* pd, void* addr, size_t length, int access);

// 使用IOVA地址注册内存区域（MR）
scclResult_t wrap_ibv_reg_mr_iova2(struct ibv_mr** ret, struct ibv_pd* pd, void* addr, size_t length, uint64_t iova, int access);

// 注册DMA-BUF内存区域（MR）
scclResult_t wrap_ibv_reg_dmabuf_mr(struct ibv_mr** ret, struct ibv_pd* pd, uint64_t offset, size_t length, uint64_t iova, int fd, int access);

// 直接注册DMA-BUF内存区域（MR）
struct ibv_mr* wrap_direct_ibv_reg_dmabuf_mr(struct ibv_pd* pd, uint64_t offset, size_t length, uint64_t iova, int fd, int access);

// 注销内存区域（MR）
scclResult_t wrap_ibv_dereg_mr(struct ibv_mr* mr);

// 创建完成通道（CQ）
scclResult_t wrap_ibv_create_comp_channel(struct ibv_comp_channel** ret, struct ibv_context* context);

// 销毁完成通道（CQ）
scclResult_t wrap_ibv_destroy_comp_channel(struct ibv_comp_channel* channel);

// 创建完成队列（CQ）
scclResult_t wrap_ibv_create_cq(struct ibv_cq** ret, struct ibv_context* context, int cqe, void* cq_context, struct ibv_comp_channel* channel, int comp_vector);

// 销毁完成队列（CQ）
scclResult_t wrap_ibv_destroy_cq(struct ibv_cq* cq);

// 轮询完成队列（CQ）
scclResult_t wrap_ibv_poll_cq(struct ibv_cq* cq, int num_entries, struct ibv_wc* wc, int* num_done);

// 创建队列对（QP）
scclResult_t wrap_ibv_create_qp(struct ibv_qp** ret, struct ibv_pd* pd, struct ibv_qp_init_attr* qp_init_attr);

// 修改队列对（QP）属性
scclResult_t wrap_ibv_modify_qp(struct ibv_qp* qp, struct ibv_qp_attr* attr, int attr_mask);

// 销毁队列对（QP）
scclResult_t wrap_ibv_destroy_qp(struct ibv_qp* qp);

// 发送数据
scclResult_t wrap_ibv_post_send(struct ibv_qp* qp, struct ibv_send_wr* wr, struct ibv_send_wr** bad_wr);

// 接收数据
scclResult_t wrap_ibv_post_recv(struct ibv_qp* qp, struct ibv_recv_wr* wr, struct ibv_recv_wr** bad_wr);

// 获取事件类型字符串
scclResult_t wrap_ibv_event_type_str(char** ret, enum ibv_event_type event);

} // namespace net_ib
} // namespace net
} // namespace hardware
} // namespace sccl
