#pragma once

#include <infiniband/verbs.h>
#include "base.h"

namespace sccl {
namespace hardware {
namespace net {
namespace net_ib {

/* IB Verbs Function Pointers*/
struct scclIbvSymbols {
    int (*ibv_internal_fork_init)(void);                                                                                           // 初始化fork支持
    struct ibv_device** (*ibv_internal_get_device_list)(int* num_devices);                                                         // 获取设备列表
    void (*ibv_internal_free_device_list)(struct ibv_device** list);                                                               // 释放设备列表
    const char* (*ibv_internal_get_device_name)(struct ibv_device* device);                                                        // 获取设备名称
    struct ibv_context* (*ibv_internal_open_device)(struct ibv_device* device);                                                    // 打开设备
    int (*ibv_internal_close_device)(struct ibv_context* context);                                                                 // 关闭设备
    int (*ibv_internal_get_async_event)(struct ibv_context* context, struct ibv_async_event* event);                               // 获取异步事件
    void (*ibv_internal_ack_async_event)(struct ibv_async_event* event);                                                           // 确认异步事件
    int (*ibv_internal_query_device)(struct ibv_context* context, struct ibv_device_attr* device_attr);                            // 查询设备属性
    int (*ibv_internal_query_port)(struct ibv_context* context, uint8_t port_num, struct ibv_port_attr* port_attr);                // 查询端口属性
    int (*ibv_internal_query_gid)(struct ibv_context* context, uint8_t port_num, int index, union ibv_gid* gid);                   // 查询全局标识符
    int (*ibv_internal_query_qp)(struct ibv_qp* qp, struct ibv_qp_attr* attr, int attr_mask, struct ibv_qp_init_attr* init_attr);  // 查询队列对属性
    struct ibv_pd* (*ibv_internal_alloc_pd)(struct ibv_context* context);                                                          // 分配保护域
    int (*ibv_internal_dealloc_pd)(struct ibv_pd* pd);                                                                             // 释放保护域
    struct ibv_mr* (*ibv_internal_reg_mr)(struct ibv_pd* pd, void* addr, size_t length, int access);                               // 注册内存区域
    struct ibv_mr* (*ibv_internal_reg_mr_iova2)(struct ibv_pd* pd, void* addr, size_t length, uint64_t iova, unsigned int access); // 注册内存区域（IOVA版本）
    /* DMA-BUF support */
    struct ibv_mr* (*ibv_internal_reg_dmabuf_mr)(struct ibv_pd* pd, uint64_t offset, size_t length, uint64_t iova, int fd, int access); // 注册DMA-BUF内存区域
    int (*ibv_internal_dereg_mr)(struct ibv_mr* mr);                                                                                    // 注销内存区域
    struct ibv_cq* (*ibv_internal_create_cq)(
        struct ibv_context* context, int cqe, void* cq_context, struct ibv_comp_channel* channel, int comp_vector); // 创建完成队列
    int (*ibv_internal_destroy_cq)(struct ibv_cq* cq);                                                              // 销毁完成队列
    struct ibv_qp* (*ibv_internal_create_qp)(struct ibv_pd* pd, struct ibv_qp_init_attr* qp_init_attr);             // 创建队列对
    int (*ibv_internal_modify_qp)(struct ibv_qp* qp, struct ibv_qp_attr* attr, int attr_mask);                      // 修改队列对属性
    int (*ibv_internal_destroy_qp)(struct ibv_qp* qp);                                                              // 销毁队列对
    const char* (*ibv_internal_event_type_str)(enum ibv_event_type event);                                          // 获取事件类型字符串
};

/* Constructs IB verbs symbols per rdma-core linking or dynamic loading mode */
scclResult_t buildIbvSymbols(struct scclIbvSymbols* ibvSymbols);

} // namespace net_ib
} // namespace net
} // namespace hardware
} // namespace sccl
